export declare const enum PlatformType {
    Desktop = "desktop",
    Mobile = "mobile",
    Console = "console",
    Tablet = "tablet",
    Unknown = "unknown"
}
export declare namespace Platform {
    /**
     * Gets the aspect ratio of this device
     * @rbxts client
     */
    function GetAspectRatio(): [number, number];
    /**
     * Gets the type of platform the user is on
     *
     * Results: `desktop`, `mobile`, `tablet`, `console`.
     *
     * @rbxts client
     */
    function GetPlatformType(): PlatformType;
}
