-- Compiled with https://roblox-ts.github.io v0.2.14
-- October 7, 2019, 5:57 PM New Zealand Daylight Time

local exports = {};
local Platform;
local Workspace = game:GetService("Workspace");
local UserInputService = game:GetService("UserInputService");
local GuiService = game:GetService("GuiService");
Platform = Platform or {} do
	local _0 = Platform;
	local gcd;
	local function getViewportSize()
		return Workspace.CurrentCamera.ViewportSize;
	end;
	function gcd(a, b)
		if b == 0 then
			return a;
		end;
		return gcd(b, a % b);
	end;
	local function GetAspectRatio()
		local vpSize = getViewportSize();
		local result = gcd(vpSize.X, vpSize.Y);
		return { vpSize.X / result, vpSize.Y / result };
	end;
	local function GetPlatformType()
		local hasGamepad = UserInputService.GamepadEnabled;
		local hasTouch = UserInputService.TouchEnabled;
		local hasKeyboard = UserInputService.KeyboardEnabled;
		if hasGamepad and GuiService:IsTenFootInterface() then
			return "console";
		elseif hasTouch and not hasKeyboard then
			local size = getViewportSize();
			if size.X >= 1023 and size.Y >= 767 then
				return "tablet";
			else
				return "mobile";
			end;
		elseif hasKeyboard then
			return "desktop";
		else
			return "unknown";
		end;
	end;
	_0.GetAspectRatio = GetAspectRatio;
	_0.GetPlatformType = GetPlatformType;
end;
exports.Platform = Platform;
return exports;
