/// <reference types="@rbxts/types" />
export declare const enum DeviceType {
    Desktop = "desktop",
    Mobile = "mobile",
    Console = "console",
    Tablet = "tablet",
    Unknown = "unknown"
}
export declare namespace Device {
    /**
     * Gets the viewport size
     */
    function GetViewportSize(): Vector2;
    /**
     * Gets the viewport size, subtracting the inset
     */
    function GetViewportSizeWithInset(): Vector2;
    /**
     * Gets the aspect ratio of this device
     * @rbxts client
     */
    function GetAspectRatio(): [number, number];
    /**
     * Gets the type of platform the user is on
     *
     * Results: `desktop`, `mobile`, `tablet`, `console`.
     *
     * @rbxts client
     */
    function GetPlatformType(): DeviceType;
}
