-- Compiled with https://roblox-ts.github.io v0.2.14
-- October 7, 2019, 6:07 PM New Zealand Daylight Time

local exports = {};
local Device;
local Workspace = game:GetService("Workspace");
local UserInputService = game:GetService("UserInputService");
local GuiService = game:GetService("GuiService");
Device = Device or {} do
	local _0 = Device;
	local gcd;
	function gcd(a, b)
		if b == 0 then
			return a;
		end;
		return gcd(b, a % b);
	end;
	local function GetViewportSize()
		if typeof(Workspace.CurrentCamera) == "Instance" then
			return Workspace.CurrentCamera.ViewportSize;
		else
			return Vector2.new();
		end;
	end;
	local function GetViewportSizeWithInset()
		local topLeft, bottomRight = GuiService:GetGuiInset();
		local vpSize = GetViewportSize();
		return ((vpSize - (topLeft)) - (bottomRight));
	end;
	local function GetAspectRatio()
		local vpSize = GetViewportSize();
		local result = gcd(vpSize.X, vpSize.Y);
		return { vpSize.X / result, vpSize.Y / result };
	end;
	local function GetPlatformType()
		local hasGamepad = UserInputService.GamepadEnabled;
		local hasTouch = UserInputService.TouchEnabled;
		local hasKeyboard = UserInputService.KeyboardEnabled;
		if hasGamepad and (GuiService:IsTenFootInterface()) then
			return "console";
		elseif hasTouch and (not (hasKeyboard)) then
			local size = GetViewportSize();
			if (size.X >= 1023) and (size.Y >= 767) then
				return "tablet";
			else
				return "mobile";
			end;
		elseif hasKeyboard then
			return "desktop";
		else
			return "unknown";
		end;
	end;
	_0.GetViewportSize = GetViewportSize;
	_0.GetViewportSizeWithInset = GetViewportSizeWithInset;
	_0.GetAspectRatio = GetAspectRatio;
	_0.GetPlatformType = GetPlatformType;
end;
exports.Device = Device;
return exports;
