/*!
 * lunr.stopWordFilter
 * Copyright (C) @YEAR Oliver Nightingale
 */

/**
 * lunr.stopWordFilter is an English language stop word list filter, any words
 * contained in the list will not be passed through the filter.
 *
 * This is intended to be used in the Pipeline. If the token does not pass the
 * filter then undefined will be returned.
 *
 * @module
 * @param {String} token The token to pass through the filter
 * @returns {String}
 * @see lunr.Pipeline
 */
lunr.stopWordFilter = function (token) {
  if (token && lunr.stopWordFilter.stopWords[token] !== token) return token;
}

lunr.stopWordFilter.stopWords = {
  'a': 'a',
  'able': 'able',
  'about': 'about',
  'across': 'across',
  'after': 'after',
  'all': 'all',
  'almost': 'almost',
  'also': 'also',
  'am': 'am',
  'among': 'among',
  'an': 'an',
  'and': 'and',
  'any': 'any',
  'are': 'are',
  'as': 'as',
  'at': 'at',
  'be': 'be',
  'because': 'because',
  'been': 'been',
  'but': 'but',
  'by': 'by',
  'can': 'can',
  'cannot': 'cannot',
  'could': 'could',
  'dear': 'dear',
  'did': 'did',
  'do': 'do',
  'does': 'does',
  'either': 'either',
  'else': 'else',
  'ever': 'ever',
  'every': 'every',
  'for': 'for',
  'from': 'from',
  'get': 'get',
  'got': 'got',
  'had': 'had',
  'has': 'has',
  'have': 'have',
  'he': 'he',
  'her': 'her',
  'hers': 'hers',
  'him': 'him',
  'his': 'his',
  'how': 'how',
  'however': 'however',
  'i': 'i',
  'if': 'if',
  'in': 'in',
  'into': 'into',
  'is': 'is',
  'it': 'it',
  'its': 'its',
  'just': 'just',
  'least': 'least',
  'let': 'let',
  'like': 'like',
  'likely': 'likely',
  'may': 'may',
  'me': 'me',
  'might': 'might',
  'most': 'most',
  'must': 'must',
  'my': 'my',
  'neither': 'neither',
  'no': 'no',
  'nor': 'nor',
  'not': 'not',
  'of': 'of',
  'off': 'off',
  'often': 'often',
  'on': 'on',
  'only': 'only',
  'or': 'or',
  'other': 'other',
  'our': 'our',
  'own': 'own',
  'rather': 'rather',
  'said': 'said',
  'say': 'say',
  'says': 'says',
  'she': 'she',
  'should': 'should',
  'since': 'since',
  'so': 'so',
  'some': 'some',
  'than': 'than',
  'that': 'that',
  'the': 'the',
  'their': 'their',
  'them': 'them',
  'then': 'then',
  'there': 'there',
  'these': 'these',
  'they': 'they',
  'this': 'this',
  'tis': 'tis',
  'to': 'to',
  'too': 'too',
  'twas': 'twas',
  'us': 'us',
  'wants': 'wants',
  'was': 'was',
  'we': 'we',
  'were': 'were',
  'what': 'what',
  'when': 'when',
  'where': 'where',
  'which': 'which',
  'while': 'while',
  'who': 'who',
  'whom': 'whom',
  'why': 'why',
  'will': 'will',
  'with': 'with',
  'would': 'would',
  'yet': 'yet',
  'you': 'you',
  'your': 'your'
}

lunr.Pipeline.registerFunction(lunr.stopWordFilter, 'stopWordFilter')
