﻿"use strict";

var Path = require("path");
var Webpack = require("webpack");
var HtmlWebpackPlugin = require("html-webpack-plugin");

module.exports = {
    entry: {
        app: "./app/main",
        vendor: "./app/vendor"
    },
    output: {
        filename: "./dist/[name].[chunkhash].bundle.js",
        chunkFilename: "./dist/[id].[chunkhash].bundle.js" 
    },

    //devServer: {
    //    contentBase: ".",
    //    host: "localhost",
    //    port: 8080
    //},

    resolve: {
        extensions: ["", ".js", ".ts"]
    },

    resolveLoader: {
        root: Path.resolve("./node_modules")
    },

    //devtool: "source-map",

    module: {
        loaders: [
            { test: /\.ts$/, loader: "ts-loader" }
        ]
    },

    //externals: {
        
    //},

    plugins: [
        new Webpack.optimize.CommonsChunkPlugin(/* chunkName= */"vendor", /* filename= */"./dist/[name].[hash].bundle.js"),

        new HtmlWebpackPlugin({
            title: "Spike - Angular 2 / Typescript / WebPack",
            template: "index.template.html",
            filename: "index.html"
        }),

        new Webpack.optimize.UglifyJsPlugin({
            sourceMap: false,
            mangle: false
        })
    ]
};