"use strict";
var smart_table_action_params_model_1 = require('./../../model/actions/smart-table-action-params.model');
var smart_table_action_model_1 = require('./../../model/actions/smart-table-action.model');
var smart_table_actions_service_1 = require('./../../services/smart-table-actions.service');
var core_1 = require('@angular/core');
var HeaderActionComponent = (function () {
    function HeaderActionComponent(actionService, changeDetectRef) {
        this.actionService = actionService;
        this.changeDetectRef = changeDetectRef;
        this.displayLength = true;
        this.optionsDisplayProperty = 'label';
        this.isSmartSelectorEnabled = true;
        this.selected = new core_1.EventEmitter();
        this.rowSelections = new Array();
    }
    HeaderActionComponent.prototype.onHeaderAction = function (event) {
        this.selected.emit(event);
    };
    HeaderActionComponent.prototype.ngOnInit = function () {
        var _this = this;
        this.actionService.onRowSelection().subscribe(function (rows) {
            _this.rowSelections = rows;
            if (_this.headerActionModel.$isActionValidForAllRequired) {
                var actionValidationParams = new smart_table_action_params_model_1.ActionValidationParams();
                actionValidationParams.rowSelections = _this.rowSelections;
                actionValidationParams.actionModel = _this.headerActionModel;
                _this.actionService.getActionValidForAllSource().next(actionValidationParams);
            }
        });
        this.actionService.onActionValidForAllResponse().subscribe(function (resp) {
            if (resp.actionModel instanceof smart_table_action_model_1.HeaderActionModel) {
                _this.headerActionModel.$actions = resp.actionModel.$actions;
                _this.changeDetectRef.markForCheck();
            }
        });
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], HeaderActionComponent.prototype, "displayLength", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', smart_table_action_model_1.HeaderActionModel)
    ], HeaderActionComponent.prototype, "headerActionModel", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], HeaderActionComponent.prototype, "optionsDisplayProperty", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], HeaderActionComponent.prototype, "isSmartSelectorEnabled", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], HeaderActionComponent.prototype, "selected", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Array)
    ], HeaderActionComponent.prototype, "rowSelections", void 0);
    HeaderActionComponent = __decorate([
        core_1.Component({
            selector: 'header-action-component',
            template: "\n        <ng2-dropdown-comp [label]=\"headerActionModel.label\" [displayLength]=\"false\" (selected)=\"onHeaderAction($event)\"\n                           optionsDisplayProperty=\"name\" [isSmartSelectorEnabled]=\"false\"\n                           [data]=\"headerActionModel | objectFilter: 'actions'\">\n        </ng2-dropdown-comp>\n    ",
            changeDetection: core_1.ChangeDetectionStrategy.OnPush
        }), 
        __metadata('design:paramtypes', [smart_table_actions_service_1.SmartTableActionService, core_1.ChangeDetectorRef])
    ], HeaderActionComponent);
    return HeaderActionComponent;
}());
exports.HeaderActionComponent = HeaderActionComponent;
//# sourceMappingURL=header-action.component.js.map