"use strict";
var constants_1 = require('./../../utils/constants');
var object_utils_1 = require('./../../utils/object-utils');
var core_1 = require('@angular/core');
var async_1 = require('@angular/forms/src/facade/async');
var moment_ = require('moment');
var moment = moment_.default || moment_;
var DatePickerComponent = (function () {
    function DatePickerComponent() {
        this.opened = false;
        this.format = 'shortDate';
        this.dateChanged = new async_1.EventEmitter();
        if (this.dt == null || this.dt == undefined) {
            this.dt = moment(new Date(), constants_1.Constants.DATE_FORMAT).toDate();
        }
    }
    DatePickerComponent.prototype.today = function () {
        this.dt = moment(new Date(), constants_1.Constants.DATE_FORMAT).toDate();
        this.inputDate = this.dt;
    };
    DatePickerComponent.prototype.disabled = function (date, mode) {
        return (mode === 'day' && (date.getDay() === 0 || date.getDay() === 6));
    };
    DatePickerComponent.prototype.open = function () {
        this.opened = !this.opened;
    };
    DatePickerComponent.prototype.clear = function () {
        this.dt = void 0;
        this.inputDate = null;
    };
    DatePickerComponent.prototype.toggle = function () {
        this.opened = !this.opened;
    };
    DatePickerComponent.prototype.onDateChange = function (event) {
        if (event.target.value) {
            var newDate = moment(event.target.value, constants_1.Constants.DATE_FORMAT).toDate();
            if (newDate && newDate != 'Invalid Date') {
                this.dt = newDate;
                this.inputDate = newDate;
                this.dateChanged.emit(this.dt);
            }
        }
    };
    DatePickerComponent.prototype.onDateSelection = function (date) {
        if (object_utils_1.ObjectUtils.isNotNullAndUndefined(date)) {
            var newDate = moment(date, constants_1.Constants.DATE_FORMAT).toDate();
            if (newDate && newDate != 'Invalid Date') {
                this.inputDate = newDate;
                this.dateChanged.emit(newDate);
            }
        }
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], DatePickerComponent.prototype, "opened", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], DatePickerComponent.prototype, "format", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], DatePickerComponent.prototype, "id", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], DatePickerComponent.prototype, "placeHolder", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', async_1.EventEmitter)
    ], DatePickerComponent.prototype, "dateChanged", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Date)
    ], DatePickerComponent.prototype, "dt", void 0);
    DatePickerComponent = __decorate([
        core_1.Component({
            selector: 'ng2-datepicker',
            moduleId: module.id,
            templateUrl: 'ng2-datepicker.component.html',
        }), 
        __metadata('design:paramtypes', [])
    ], DatePickerComponent);
    return DatePickerComponent;
}());
exports.DatePickerComponent = DatePickerComponent;
//# sourceMappingURL=ng2-datepicker.component.js.map