"use strict";
var smart_table_actions_service_1 = require('./../../services/smart-table-actions.service');
var object_utils_1 = require('./../../utils/object-utils');
var core_1 = require('@angular/core');
var _ = require('underscore');
var Ng2DropDownComponent = (function () {
    function Ng2DropDownComponent(actionService) {
        this.actionService = actionService;
        this.selected = new core_1.EventEmitter();
        this.optionsDisplayProperty = 'label';
        this.isSmartSelectorEnabled = true;
        this.dropdownNotCloseZone = null;
        this.displayLength = true;
        this.displayRowSelections = false;
        this.rowSelections = new Array();
        this.edited = new core_1.EventEmitter();
        this.getToolTip = function getToolTip() {
            if (this.data.length === 1) {
                return this.data[0][this.optionsDisplayProperty];
            }
            return this.label;
        };
        this.onChange = function onChange(event, option) {
            event.selectedOption = option;
            this.edited.emit(event);
        };
        this.onSelect = function onSelect(event, option) {
            if (object_utils_1.ObjectUtils.isNullOrUndefined(this.label)) {
                this.displayValue = option.label;
            }
            event.selectedOption = option;
            event.selectedRows = this.rowSelections;
            this.selected.emit(event, this.optionsDisplayProperty);
        };
        this.onBtnClick = function onBtnClick(event, option) {
            if (this.data.length === 1)
                this.onSelect(event, option);
            else
                event.stopPropagation();
        };
    }
    Ng2DropDownComponent.prototype.ngOnInit = function () {
        var _this = this;
        this.actionService.onRowSelection().subscribe(function (rows) {
            _this.rowSelections = rows;
        });
    };
    /*
     ngOnChanges(changes:{[propertyName:string]:SimpleChange}):void{
     if(changes['data'] && this.data && _.size(this.data)>0 ){
     if(typeof this.data[0] === 'string' || Number){
     this.data = this.getArrayOfObjects(this.data);
     }
     }

     } */
    Ng2DropDownComponent.prototype.getArryOfObjects = function (data) {
        var listOfObjects = new Array();
        data.forEach(function (item) {
            var obj = new Object();
            obj['id'] = item;
            obj['label'] = item;
            listOfObjects.push(obj);
        });
        return listOfObjects;
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], Ng2DropDownComponent.prototype, "label", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], Ng2DropDownComponent.prototype, "selected", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], Ng2DropDownComponent.prototype, "optionsDisplayProperty", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], Ng2DropDownComponent.prototype, "optionsVisibility", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], Ng2DropDownComponent.prototype, "isSmartSelectorEnabled", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], Ng2DropDownComponent.prototype, "dropdownNotCloseZone", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], Ng2DropDownComponent.prototype, "displayLength", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Array)
    ], Ng2DropDownComponent.prototype, "data", void 0);
    __decorate([
        // Excepting [{visible:true,title:'Sample'}]
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], Ng2DropDownComponent.prototype, "displayRowSelections", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], Ng2DropDownComponent.prototype, "toolTip", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Array)
    ], Ng2DropDownComponent.prototype, "rowSelections", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], Ng2DropDownComponent.prototype, "edited", void 0);
    Ng2DropDownComponent = __decorate([
        core_1.Component({
            selector: 'ng2-dropdown-comp',
            templateUrl: 'ng2-dropdown.component.html',
            styleUrls: ['ng2dropdown.css']
        }), 
        __metadata('design:paramtypes', [smart_table_actions_service_1.SmartTableActionService])
    ], Ng2DropDownComponent);
    return Ng2DropDownComponent;
}());
exports.Ng2DropDownComponent = Ng2DropDownComponent;
//# sourceMappingURL=ng2dropdown.component.js.map