"use strict";
var constants_1 = require('../../../../../../../utils/constants');
var object_utils_1 = require('./../../../../../../../utils/object-utils');
var core_1 = require('@angular/core');
var moment = require('moment');
var DateTemplate = (function () {
    function DateTemplate() {
        this.dates = { low: null, high: null };
        this.searched = new core_1.EventEmitter();
    }
    DateTemplate.prototype.ngOnChanges = function (changes) {
        if (changes['value'] && typeof this.value === 'string') {
            if (object_utils_1.ObjectUtils.isNotNullAndUndefined(this.value))
                this.value = moment(this.value).format(constants_1.Constants.DATE_FORMAT);
        }
    };
    DateTemplate.prototype.onDateChange = function (event, key) {
        if (key === 'beforeDate') {
            this.dates.high = moment(event).format(constants_1.Constants.DATE_FORMAT);
        }
        else {
            this.dates.low = moment(event).format(constants_1.Constants.DATE_FORMAT);
            ;
        }
        this.searched.emit(this.dates);
    };
    DateTemplate.prototype.isHighAlone = function () {
        return object_utils_1.ObjectUtils.isNotNullAndUndefined(this.value.high) && object_utils_1.ObjectUtils.isNullOrUndefined(this.value.low);
    };
    DateTemplate.prototype.isLowAlone = function () {
        return object_utils_1.ObjectUtils.isNotNullAndUndefined(this.value.low) && object_utils_1.ObjectUtils.isNullOrUndefined(this.value.high);
    };
    DateTemplate.prototype.isHighAndLowAvailable = function () {
        return object_utils_1.ObjectUtils.isNotNullAndUndefined(this.value.high) && object_utils_1.ObjectUtils.isNotNullAndUndefined(this.value.low);
    };
    DateTemplate.prototype.getDate = function (date) {
        if (object_utils_1.ObjectUtils.isNotNullAndUndefined(date))
            return moment(date, constants_1.Constants.DATE_FORMAT).toDate();
        return new Date();
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], DateTemplate.prototype, "type", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], DateTemplate.prototype, "value", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], DateTemplate.prototype, "id", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], DateTemplate.prototype, "title", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], DateTemplate.prototype, "uniqueid", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], DateTemplate.prototype, "searched", void 0);
    DateTemplate = __decorate([
        core_1.Component({
            selector: 'date-template',
            templateUrl: './date-template.component.html'
        }), 
        __metadata('design:paramtypes', [])
    ], DateTemplate);
    return DateTemplate;
}());
exports.DateTemplate = DateTemplate;
//# sourceMappingURL=date-template.component.js.map