"use strict";
var core_1 = require('@angular/core');
var ModalEventsDirective = (function () {
    function ModalEventsDirective(_elementRef) {
        this._elementRef = _elementRef;
        this.closeOutSide = new core_1.EventEmitter();
        this.isModalOpen = false;
    }
    ModalEventsDirective.prototype.onClick = function (targetElement, event) {
        console.log('document:click triggered');
        if (this.isModalOpen) {
            var clickedInside = this._elementRef.nativeElement.contains(targetElement);
            if (!clickedInside) {
                this.closeOutSide.emit(event);
                this.isModalOpen = false;
            }
        }
        else {
            this.isModalOpen = true;
        }
    };
    ModalEventsDirective.prototype.onEsc = function (event) {
        console.log(event);
        this.closeOutSide.emit(event);
    };
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], ModalEventsDirective.prototype, "closeOutSide", void 0);
    __decorate([
        core_1.HostListener('document:click', ['$event.target']), 
        __metadata('design:type', Function), 
        __metadata('design:paramtypes', [Object, Object]), 
        __metadata('design:returntype', void 0)
    ], ModalEventsDirective.prototype, "onClick", null);
    __decorate([
        core_1.HostListener('keydown.esc', ['$event']), 
        __metadata('design:type', Function), 
        __metadata('design:paramtypes', [Object]), 
        __metadata('design:returntype', void 0)
    ], ModalEventsDirective.prototype, "onEsc", null);
    ModalEventsDirective = __decorate([
        core_1.Directive({
            selector: '[closeOutSide]'
        }), 
        __metadata('design:paramtypes', [core_1.ElementRef])
    ], ModalEventsDirective);
    return ModalEventsDirective;
}());
exports.ModalEventsDirective = ModalEventsDirective;
//# sourceMappingURL=modal-events.directive.js.map