"use strict";
var object_utils_1 = require('./../../../../../utils/object-utils');
var smart_table_search_1 = require('./../../../services/smart-table-search');
var column_1 = require('./../../lib/data-set/column');
var core_1 = require('@angular/core');
var TemplateModal = (function () {
    function TemplateModal(searchService) {
        this.searchService = searchService;
        this.title = 'text';
        this.type = 'text';
        this.closeModal = new core_1.EventEmitter();
    }
    TemplateModal.prototype.ngOnChanges = function (changes) {
        if (object_utils_1.ObjectUtils.isNotNullAndUndefined(this.type)) {
            if (this.type === 'number') {
                this.columnType = 'numeric-search';
            }
            else {
                this.columnType = this.type + '-search';
            }
        }
    };
    TemplateModal.prototype.onColumnSearch = function (searchValue) {
        var searchParams = { key: this.column.id, value: searchValue };
        this.searchService.getSearchSource().next(searchParams);
    };
    TemplateModal.prototype.triggerCloseModal = function (event) {
        this.closeModal.emit(event);
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], TemplateModal.prototype, "title", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], TemplateModal.prototype, "type", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', column_1.Column)
    ], TemplateModal.prototype, "column", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], TemplateModal.prototype, "closeModal", void 0);
    TemplateModal = __decorate([
        core_1.Component({
            selector: 'template-modal',
            templateUrl: './template-modal.component.html',
            styleUrls: ['./template-modal.component.css']
        }), 
        __metadata('design:paramtypes', [smart_table_search_1.SmartTableSearchService])
    ], TemplateModal);
    return TemplateModal;
}());
exports.TemplateModal = TemplateModal;
//# sourceMappingURL=template-modal.component.js.map