"use strict";
var column_1 = require('./column');
var row_1 = require('./row');
var DataSet = (function () {
    function DataSet(data, columnSettings) {
        if (data === void 0) { data = new Array(); }
        this.columnSettings = columnSettings;
        this.data = new Array();
        this.columns = new Array();
        this.rows = new Array();
        this.createColumns(columnSettings);
        this.setData(data);
        this.createNewRow();
    }
    DataSet.prototype.setSelectedRows = function (selectedRows) {
        this.selectedRows = selectedRows;
        this.updateRows();
    };
    DataSet.prototype.setSelectedColumns = function (selectedColumns) {
        this.selectedColumns = selectedColumns;
        this.updateColumns();
    };
    DataSet.prototype.setData = function (data) {
        this.data = data;
        this.createRows();
    };
    DataSet.prototype.getData = function () {
        return this.data;
    };
    DataSet.prototype.getColumns = function () {
        return this.columns;
    };
    DataSet.prototype.getRows = function () {
        return this.rows;
    };
    DataSet.prototype.getSelectedRows = function () {
        return this.rows.filter(function (row) { return row.isSelected === true; });
    };
    DataSet.prototype.findRowByData = function (data) {
        return this.rows.find(function (row) { return row.getData() === data; });
    };
    DataSet.prototype.deselectAll = function () {
        this.rows.forEach(function (row) {
            row.isSelected = false;
        });
    };
    DataSet.prototype.selectRow = function (row) {
        //this.deselectAll();
        row.isSelected = true;
        this.selectedRow = row;
        return this.selectedRow;
    };
    DataSet.prototype.selectPreviousRow = function () {
        if (this.rows.length > 0) {
            var index = this.selectedRow ? this.selectedRow.id : 0;
            if (index > this.rows.length - 1) {
                index = this.rows.length - 1;
            }
            this.selectRow(this.rows[index]);
            return this.selectedRow;
        }
    };
    DataSet.prototype.selectFirstRow = function () {
        if (this.rows.length > 0) {
            this.selectRow(this.rows[0]);
            return this.selectedRow;
        }
    };
    DataSet.prototype.selectLastRow = function () {
        if (this.rows.length > 0) {
            this.selectRow(this.rows[this.rows.length - 1]);
            return this.selectedRow;
        }
    };
    DataSet.prototype.select = function () {
        if (this.getRows().length === 0) {
            return;
        }
        return this.selectedRow;
    };
    DataSet.prototype.createNewRow = function () {
        this.newRow = new row_1.Row('0', {}, this, false);
    };
    /**
     * Create columns by mapping from the settings
     * @param settings
     * @private
     */
    DataSet.prototype.createColumns = function (settings) {
        this.columns = [];
        var _loop_1 = function(id) {
            if (id) {
                var newColumn_1 = new column_1.Column(id, settings.columns[id], this_1, settings.uniqueTemplateMap);
                this_1.columns.push(newColumn_1);
                if (this_1.selectedColumns) {
                    this_1.selectedColumns.forEach(function (selectedColumn) {
                        if (id === selectedColumn.id) {
                            newColumn_1.isVisible = selectedColumn.selected;
                            return false;
                        }
                    });
                }
            }
        };
        var this_1 = this;
        for (var id in settings.columns) {
            _loop_1(id);
        }
    };
    DataSet.prototype.updateColumns = function () {
        var _this = this;
        this.columns.forEach(function (column) {
            if (_this.selectedColumns) {
                _this.selectedColumns.forEach(function (selectedColumn) {
                    if (column.id === selectedColumn.id) {
                        column.isVisible = selectedColumn.selected;
                    }
                });
            }
        });
    };
    DataSet.prototype.updateRows = function () {
        var _this = this;
        this.rows.forEach(function (row) {
            if (_this.selectedRows) {
                _this.selectedRows.forEach(function (selectedRow) {
                    var selectedId = selectedRow.hasOwnProperty('id') ? selectedRow['id'] : selectedRow.getId();
                    if (row.id === selectedId) {
                        var isSelected = selectedRow.hasOwnProperty('selected') ? selectedRow['selected'] : selectedRow.isSelected();
                        row.setSelected(isSelected);
                    }
                });
            }
        });
    };
    /**
     * Create rows based on current data prepared in data source
     * @private
     */
    DataSet.prototype.createRows = function () {
        var _this = this;
        this.rows = [];
        this.data.forEach(function (el, index) {
            var newRow = new row_1.Row(el.id, el, _this, false);
            _this.rows.push(newRow);
            /*   if (this.selectedRows) {
                    this.selectedRows.forEach(selectedRow => {
                        if (el.id === selectedRow.id) {
                            newRow.setSelected(selectedRow.selected);
                            return false;
                        }
                    });
    
            } */
        });
    };
    return DataSet;
}());
exports.DataSet = DataSet;
//# sourceMappingURL=data-set.js.map