"use strict";
var LocalSorter = (function () {
    function LocalSorter() {
    }
    LocalSorter.sort = function (data, field, direction, customCompare) {
        var dir = (direction === 'asc') ? 1 : -1;
        var compare = customCompare ? customCompare : this.COMPARE;
        return data.sort(function (a, b) {
            return compare.call(null, dir, a[field], b[field]);
        });
    };
    LocalSorter.COMPARE = function (direction, a, b) {
        if (a < b) {
            return -1 * direction;
        }
        if (a > b) {
            return direction;
        }
        return 0;
    };
    return LocalSorter;
}());
exports.LocalSorter = LocalSorter;
//# sourceMappingURL=local.sorter.js.map