"use strict";
var smart_table_rows_selections_model_1 = require('./../../model/actions/smart-table-rows-selections.model');
var select_1 = require('../../decorators/select');
var smart_table_actions_service_1 = require('../../services/smart-table-actions.service');
var smart_table_column_service_1 = require('../../services/smart-table-column.service');
var smart_table_storage_actions_1 = require('./../../actions/smart-table/smart-table-storage.actions');
var smart_table_action_params_model_1 = require('./../../model/actions/smart-table-action-params.model');
var smart_table_action_model_1 = require('./../../model/actions/smart-table-action.model');
var local_storage_service_1 = require('./../../services/local-storage.service');
var object_utils_1 = require('./../../utils/object-utils');
var action_confirm_modal_component_1 = require('./../confirm-modal/action-confirm-modal.component');
var ng2_smart_table_component_1 = require('./ng2-smart-table/ng2-smart-table.component');
var smart_table_search_1 = require('./services/smart-table-search');
var core_1 = require('@angular/core');
var core_2 = require('@angular/core');
var Rx_1 = require('rxjs/Rx');
var SmartTableComponent = (function () {
    function SmartTableComponent(injector, changeDetectRef) {
        this.injector = injector;
        this.changeDetectRef = changeDetectRef;
        this.onHeaderEvent = new core_2.EventEmitter();
        this.onRowEvent = new core_2.EventEmitter();
        this.onBulkEvent = new core_2.EventEmitter();
        this.onColumnSortEvent = new core_2.EventEmitter();
        this.onPaginateEvent = new core_2.EventEmitter();
        this.onColumnSearchEvent = new core_2.EventEmitter();
        this.onRowClickEvent = new core_2.EventEmitter();
        this.onPreviousRowEvent = new core_2.EventEmitter();
        this.onNextRowEvent = new core_2.EventEmitter();
        this.settingsSource = new Rx_1.Subject();
        this.settings$ = this.settingsSource.asObservable();
        this.dataSource = new Rx_1.Subject();
        this.dataSource$ = this.dataSource.asObservable();
        this.columnService = injector.get(smart_table_column_service_1.SmartTableColumnService);
        this.actionService = injector.get(smart_table_actions_service_1.SmartTableActionService);
        this.searchService = injector.get(smart_table_search_1.SmartTableSearchService);
        this.smartTableStorageActions = injector.get(smart_table_storage_actions_1.SmartTableStorageActions);
        this.localStorageService = injector.get(local_storage_service_1.LocalStorageService);
    }
    SmartTableComponent.prototype.ngOnChanges = function (changes) {
        if (changes['columnJson']) {
            this.setSettings(this.columnJson);
        }
        if (changes['data'])
            this.dataSource.next(this.data);
        if (changes['storageKey'])
            this.localStorageService.updateKey(this.storageKey);
    };
    SmartTableComponent.prototype.ngOnInit = function () {
        this.initConfirmationMessageSubscribe();
        this.initActionSubscribe();
        this.initSearchSubscribe();
    };
    SmartTableComponent.prototype.initConfirmationMessageSubscribe = function () {
        var _this = this;
        this.actionService.onActionConfirmationMessageResp().subscribe(function (param) {
            _this.confirm.showConfirm(param);
        });
    };
    SmartTableComponent.prototype.initSearchSubscribe = function () {
        var _this = this;
        this.searchService.onSearchAsObservable().subscribe(function (searchParam) {
            _this.onColumnSearchEvent.emit(searchParam);
            _this.smartTableStorageActions.onColumnSearch(searchParam);
        });
    };
    SmartTableComponent.prototype.initActionSubscribe = function () {
        var _this = this;
        this.actionService.onActionConfirmation().subscribe(function (param) {
            if (param instanceof smart_table_action_params_model_1.BulkActionParams) {
                _this.actionService.getPerformedBulkActionSource().next(param);
            }
            else if (param instanceof smart_table_action_params_model_1.HeaderActionParams) {
                _this.actionService.getPerformedHeaderActionSource().next(param);
            }
            else if (param instanceof smart_table_action_params_model_1.RowActionParams) {
                _this.actionService.getPerformedRowActionSource().next(param);
            }
        });
    };
    SmartTableComponent.prototype.setSettings = function (columnJsonName) {
        var _this = this;
        if (columnJsonName) {
            this.columnService.getColumns(columnJsonName).subscribe(function (columns) {
                var settings = {
                    hideHeader: false,
                    hideSubHeader: true,
                    columns: columns,
                    actions: null,
                    pageRows: [
                        { 'id': 10, 'label': 10 }, { 'id': 15, 'label': 15 },
                        { 'id': 25, 'label': 25 }, { 'id': 50, 'label': 50 },
                        { 'id': 100, 'label': 100 }, { 'id': 1000, 'label': 1000 }],
                    pager: {
                        display: true,
                        perPage: 50
                    }
                };
                _this.settingsSource.next(settings);
            });
        }
    };
    ;
    SmartTableComponent.prototype.onPaginate = function (event) {
        this.onPaginateEvent.emit(event);
        this.smartTableStorageActions.onPaginate(event);
    };
    SmartTableComponent.prototype.onPageSizeChanged = function (event) {
        this.smartTableStorageActions.onPaginate(event);
        // PlaceHolder to propagate onPageSizeChanged event
    };
    SmartTableComponent.prototype.onRowSelectionChange = function (rows) {
        if (rows === void 0) { rows = new Array(); }
        this.actionService.getRowSelectionSource().next(rows);
        // PlaceHolder to propagate onRowSelectionChange event
        var rowsSelection = new Array();
        rows.forEach(function (row) {
            rowsSelection.push(new smart_table_rows_selections_model_1.SmartTableSelectionData(row.id, row.isSelected));
        });
        this.changeDetectRef.markForCheck();
        this.smartTableStorageActions.onRowSelectionChange(rowsSelection);
    };
    SmartTableComponent.prototype.onColumnSelectionChange = function (columns) {
        var columnsSelection = new Array();
        columns.forEach(function (column) {
            columnsSelection.push(new smart_table_rows_selections_model_1.SmartTableSelectionData(column.id, column.isVisible));
        });
        this.changeDetectRef.markForCheck();
        this.smartTableStorageActions.onColumnSelectionChange(columnsSelection);
        // PlaceHolder to propagate onRowSelectionChange event
    };
    SmartTableComponent.prototype.onColumnSort = function (sorts) {
        this.onColumnSortEvent.emit(sorts);
        this.smartTableStorageActions.onColumnSort(sorts);
    };
    SmartTableComponent.prototype.onHeaderAction = function (event) {
        var headerActionParam = new smart_table_action_params_model_1.HeaderActionParams();
        headerActionParam.selectedRows = event.selectedRows;
        headerActionParam.selectedHeaderAction = event.selectedOption;
        if (object_utils_1.ObjectUtils.isNotNullAndUndefined(headerActionParam.selectedHeaderAction.$confirmFunc)) {
            this.actionService.getActionConfirmationMessageSource().next(headerActionParam);
        }
        else {
            this.actionService.getPerformedHeaderActionSource().next(headerActionParam);
        }
    };
    SmartTableComponent.prototype.onRowAction = function (event) {
        var rowActionParam = new smart_table_action_params_model_1.RowActionParams();
        rowActionParam.selectedRows = [event.selectedRow];
        rowActionParam.selectedRowAction = event.selectedOption;
        if (object_utils_1.ObjectUtils.isNotNullAndUndefined(rowActionParam.selectedRowAction.$confirmFunc)) {
            this.actionService.getActionConfirmationMessageSource().next(rowActionParam);
        }
        else {
            this.actionService.getPerformedRowActionSource().next(rowActionParam);
        }
    };
    SmartTableComponent.prototype.onBulkAction = function (event) {
        var bulkActionParams = new smart_table_action_params_model_1.BulkActionParams();
        bulkActionParams.selectedBulkAction = event.selectedOption;
        bulkActionParams.selectedRows = event.rowSelections;
        if (object_utils_1.ObjectUtils.isNotNullAndUndefined(bulkActionParams.selectedBulkAction.$confirmFunc)) {
            this.actionService.getActionConfirmationMessageSource().next(bulkActionParams);
        }
        else {
            this.actionService.getPerformedBulkActionSource().next(bulkActionParams);
        }
    };
    SmartTableComponent.prototype.onRowClick = function (event) {
        this.onRowClickEvent.emit(event);
    };
    SmartTableComponent.prototype.onPrevious = function (event) {
        this.onPreviousRowEvent.emit(event);
    };
    SmartTableComponent.prototype.onNext = function (event) {
        this.onNextRowEvent.emit(event);
    };
    __decorate([
        core_2.ViewChild(action_confirm_modal_component_1.ActionConfirmModalComponent), 
        __metadata('design:type', action_confirm_modal_component_1.ActionConfirmModalComponent)
    ], SmartTableComponent.prototype, "confirm", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], SmartTableComponent.prototype, "columnJson", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Array)
    ], SmartTableComponent.prototype, "data", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], SmartTableComponent.prototype, "storageKey", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', smart_table_action_model_1.SmartTableActionModel)
    ], SmartTableComponent.prototype, "actionModel", void 0);
    __decorate([
        core_2.Output(), 
        __metadata('design:type', core_2.EventEmitter)
    ], SmartTableComponent.prototype, "onHeaderEvent", void 0);
    __decorate([
        core_2.Output(), 
        __metadata('design:type', core_2.EventEmitter)
    ], SmartTableComponent.prototype, "onRowEvent", void 0);
    __decorate([
        core_2.Output(), 
        __metadata('design:type', core_2.EventEmitter)
    ], SmartTableComponent.prototype, "onBulkEvent", void 0);
    __decorate([
        core_2.Output(), 
        __metadata('design:type', core_2.EventEmitter)
    ], SmartTableComponent.prototype, "onColumnSortEvent", void 0);
    __decorate([
        core_2.Output(), 
        __metadata('design:type', core_2.EventEmitter)
    ], SmartTableComponent.prototype, "onPaginateEvent", void 0);
    __decorate([
        core_2.Output(), 
        __metadata('design:type', core_2.EventEmitter)
    ], SmartTableComponent.prototype, "onColumnSearchEvent", void 0);
    __decorate([
        core_2.Output(), 
        __metadata('design:type', core_2.EventEmitter)
    ], SmartTableComponent.prototype, "onRowClickEvent", void 0);
    __decorate([
        core_2.Output(), 
        __metadata('design:type', core_2.EventEmitter)
    ], SmartTableComponent.prototype, "onPreviousRowEvent", void 0);
    __decorate([
        core_2.Output(), 
        __metadata('design:type', core_2.EventEmitter)
    ], SmartTableComponent.prototype, "onNextRowEvent", void 0);
    __decorate([
        select_1.select(['smartTable', 'smartTableSort']), 
        __metadata('design:type', Rx_1.Observable)
    ], SmartTableComponent.prototype, "sortSelections$", void 0);
    __decorate([
        select_1.select(['smartTable', 'smartTableColumnSelection']), 
        __metadata('design:type', Rx_1.Observable)
    ], SmartTableComponent.prototype, "columnSelections$", void 0);
    __decorate([
        select_1.select(['smartTable', 'smartTablePager']), 
        __metadata('design:type', Rx_1.Observable)
    ], SmartTableComponent.prototype, "pagerSelections$", void 0);
    __decorate([
        select_1.select(['smartTable', 'smartTableRowSelection']), 
        __metadata('design:type', Rx_1.Observable)
    ], SmartTableComponent.prototype, "rowSelections$", void 0);
    SmartTableComponent = __decorate([
        core_1.Component({
            selector: 'smart-table-component',
            moduleId: module.id,
            templateUrl: './smart-table.component.html',
            providers: [ng2_smart_table_component_1.Ng2SmartTableComponent, smart_table_search_1.SmartTableSearchService],
            changeDetection: core_1.ChangeDetectionStrategy.OnPush
        }), 
        __metadata('design:paramtypes', [core_1.Injector, core_1.ChangeDetectorRef])
    ], SmartTableComponent);
    return SmartTableComponent;
}());
exports.SmartTableComponent = SmartTableComponent;
//# sourceMappingURL=smart-table.component.js.map