"use strict";
var index_1 = require('./../store/index');
var object_utils_1 = require('./../utils/object-utils');
var core_1 = require('@angular/core');
var redux_1 = require('redux');
var Rx_1 = require('rxjs/Rx');
var LocalStorageService = (function () {
    function LocalStorageService(ngZone) {
        var _this = this;
        this.ngZone = ngZone;
        this.dispatch = new core_1.EventEmitter();
        this.stateSource = new Rx_1.Subject();
        this.storeKey = 'NO_KEY_SPECIFIED';
        LocalStorageService.INSTANCE = this;
        this._selectSource = new Rx_1.BehaviorSubject(null);
        this.stateSource.asObservable().subscribe(function (state) {
            _this.state = state;
            if (index_1.COMPONENTS_REDUCERS && state) {
                _this.storeUnSubscribe();
                _this.createReduxStoreAndSaveState(index_1.COMPONENTS_REDUCERS, state);
            }
        });
        this.dispatch.subscribe(function (dispatchParam) {
            _this.store.dispatch(_this.store.dispatch(dispatchParam));
        });
    }
    /*
     This has to be called only once of the app lifecycle
    */
    LocalStorageService.prototype.createStorage = function (initialState, rootReducers, key) {
        if (key === void 0) { key = null; }
        if (object_utils_1.ObjectUtils.isNotNullAndUndefined(key))
            this.storeKey = key;
        this.createReduxStoreAndSaveState(rootReducers, initialState);
    };
    LocalStorageService.prototype.createReduxStoreAndSaveState = function (reducers, initialState) {
        var _this = this;
        if (initialState === void 0) { initialState = {}; }
        this.store = redux_1.createStore(reducers, initialState);
        if (object_utils_1.ObjectUtils.isNotNullAndUndefined(this.store)) {
            this.storeUnSubscribe = this.store.subscribe(function () {
                _this.state = _this.store.getState();
                localStorage.setItem(_this.storeKey, JSON.stringify(_this.state));
            });
        }
    };
    LocalStorageService.prototype.getStateFromLocalStorage = function (key) {
        var storedData = JSON.parse(localStorage.getItem(key));
        return storedData;
    };
    LocalStorageService.prototype.updateKey = function (key) {
        if (object_utils_1.ObjectUtils.isNotNullAndUndefined(key)) {
            this.storeKey = key;
            this.updateState(key);
        }
    };
    LocalStorageService.prototype.updateState = function (key) {
        this.stateSource.next(this.getStateFromLocalStorage(key));
    };
    LocalStorageService.prototype.select = function (selector, comparator) {
        if (typeof selector === 'string' ||
            typeof selector === 'number' ||
            typeof selector === 'symbol') {
            this._selectSource.next(this.state[selector]);
        }
        else if (Array.isArray(selector)) {
            var results = object_utils_1.ObjectUtils.getIn(this.state, selector);
            this._selectSource.next(results);
        }
        return this._selectSource.asObservable().distinctUntilChanged(comparator);
    };
    LocalStorageService.prototype.makeAsyncDispatch = function (dispatchParam) {
        return function (dispatch, state) {
            dispatch(dispatchParam);
        };
    };
    Object.defineProperty(LocalStorageService.prototype, "$dispatch", {
        get: function () {
            return this.dispatch;
        },
        enumerable: true,
        configurable: true
    });
    LocalStorageService.prototype.ngOnDestroy = function () {
        this._selectSource.unsubscribe();
        this.stateSource.unsubscribe();
        this.$dispatch.unsubscribe();
    };
    LocalStorageService = __decorate([
        core_1.Injectable(), 
        __metadata('design:paramtypes', [core_1.NgZone])
    ], LocalStorageService);
    return LocalStorageService;
}());
exports.LocalStorageService = LocalStorageService;
//# sourceMappingURL=local-storage.service.js.map