"use strict";
var object_utils_1 = require('./../utils/object-utils');
var base_http_service_1 = require('./base-http.service');
var core_1 = require('@angular/core');
var Rx_1 = require('rxjs/Rx');
var TemplateLoaderService = (function () {
    function TemplateLoaderService(http) {
        this.http = http;
    }
    TemplateLoaderService.prototype.getTemplateContent = function (templatePath) {
        return this.http.invoke(templatePath);
    };
    TemplateLoaderService.prototype.loadTemplates = function (columns, uniqueTemplateMap, httpColumnSource) {
        var _this = this;
        var templateLoaderTracker = new Rx_1.AsyncSubject();
        templateLoaderTracker.asObservable().subscribe(function (templateLoader$) {
            templateLoader$.subscribe(function (finalResponse) {
                _this.updateColumns(columns, uniqueTemplateMap);
                httpColumnSource.complete();
            });
        });
        Object.keys(uniqueTemplateMap).forEach(function (templateType) {
            uniqueTemplateMap[templateType].forEach(function (template) {
                _this.loadTemplate(columns, uniqueTemplateMap, template, templateType, templateLoaderTracker);
            });
        });
        templateLoaderTracker.isEmpty().subscribe(function (isEmpty) {
            if (isEmpty) {
                httpColumnSource.complete();
            }
        });
        templateLoaderTracker.complete();
    };
    TemplateLoaderService.prototype.loadTemplate = function (columns, uniqueTemplateMap, template, type, templateLoaderTracker) {
        var template$ = this.getTemplateHtml(template.key);
        templateLoaderTracker.next(template$);
        template$.subscribe(function (resp) {
            template.value = resp;
        });
    };
    TemplateLoaderService.prototype.updateColumns = function (columns, uniqueTemplateMap) {
        var _this = this;
        Object.keys(columns).forEach(function (column) {
            var columnObj = columns[column];
            if (object_utils_1.ObjectUtils.isNotNullAndUndefined(columnObj['viewTemplate'])) {
                columnObj['viewTemplateHtml'] = _this.getMatchingTemplate(uniqueTemplateMap['viewTemplate'], columnObj['viewTemplate']);
            }
            if (object_utils_1.ObjectUtils.isNotNullAndUndefined(columnObj['EditTemplate'])) {
                columnObj['EditTemplateHtml'] = _this.getMatchingTemplate(uniqueTemplateMap['EditTemplate'], columnObj['EditTemplate']);
            }
            if (object_utils_1.ObjectUtils.isNotNullAndUndefined(columnObj['searchTemplate'])) {
                columnObj['searchTemplateHtml'] = _this.getMatchingTemplate(uniqueTemplateMap['searchTemplate'], columnObj['searchTemplate']);
            }
            if (object_utils_1.ObjectUtils.isNotNullAndUndefined(columnObj['searchDescriptionTemplate'])) {
                columnObj['searchDescriptionTemplateHtml'] = _this.getMatchingTemplate(uniqueTemplateMap['searchDescriptionTemplate'], columnObj['searchDescriptionTemplate']);
            }
        });
    };
    TemplateLoaderService.prototype.getMatchingTemplate = function (templateUrls, url) {
        var returnValue = '';
        templateUrls.forEach(function (template) {
            if (template.key === url) {
                returnValue = template.value;
                return true;
            }
        });
        return returnValue;
    };
    TemplateLoaderService.prototype.getTemplateHtml = function (uri) {
        var _this = this;
        var templateSource = new Rx_1.Subject();
        var template$ = templateSource.asObservable();
        this.getTemplateContent(uri).subscribe(function (data) {
            templateSource.next(data._body);
        }, function (error) { return _this.handleError(error); });
        return template$;
    };
    TemplateLoaderService.prototype.handleError = function (error) {
        console.error(error);
        return Rx_1.Observable.throw(error || 'Server error');
    };
    TemplateLoaderService = __decorate([
        core_1.Injectable(), 
        __metadata('design:paramtypes', [base_http_service_1.BaseHttpService])
    ], TemplateLoaderService);
    return TemplateLoaderService;
}());
exports.TemplateLoaderService = TemplateLoaderService;
//# sourceMappingURL=template-loader.service.js.map