"use strict";
var smart_table_storage_actions_1 = require('./../../actions/smart-table/smart-table-storage.actions');
exports.INITIAL_PAGER_STATE = {
    pager: {
        page: 1,
        perPage: 50
    }
};
exports.INITIAL_SORT_STATE = [{
        field: 'temp',
        direction: 'asc',
        compare: null
    }
];
//Sort rootReducer
function smartTableSortReducer(state, action) {
    if (state === void 0) { state = exports.INITIAL_SORT_STATE; }
    switch (action.type) {
        case smart_table_storage_actions_1.SmartTableStorageActions.ON_COLUMN_SORT:
            return Object.assign([], state, action.payload);
        default:
            return state;
    }
}
exports.smartTableSortReducer = smartTableSortReducer;
//Pager reducer
function smartTablePagerReducer(state, action) {
    if (state === void 0) { state = exports.INITIAL_PAGER_STATE; }
    switch (action.type) {
        case smart_table_storage_actions_1.SmartTableStorageActions.ON_PAGINATED:
            return Object.assign({}, state, action.payload);
        default:
            return state;
    }
}
exports.smartTablePagerReducer = smartTablePagerReducer;
//Row selection Reducer
function smartTableRowSelectionReducer(state, action) {
    if (state === void 0) { state = []; }
    switch (action.type) {
        case smart_table_storage_actions_1.SmartTableStorageActions.ON_ROW_SELECTION_CHANGE: {
            return Object.assign([], state, action.payload);
        }
        default:
            return state;
    }
}
exports.smartTableRowSelectionReducer = smartTableRowSelectionReducer;
//Column selection Reducer
function smartTableColumnSelectionReducer(state, action) {
    if (state === void 0) { state = []; }
    switch (action.type) {
        case smart_table_storage_actions_1.SmartTableStorageActions.ON_COLUMN_SELECTION_CHANGE: {
            return Object.assign([], state, action.payload);
        }
        default:
            return state;
    }
}
exports.smartTableColumnSelectionReducer = smartTableColumnSelectionReducer;
//# sourceMappingURL=smart-table.reducers.js.map