"use strict";
var constants_1 = require('./../../utils/constants');
var local_storage_service_1 = require('../../services/local-storage.service');
var core_1 = require('@angular/core');
var SmartTableStorageActions = (function () {
    function SmartTableStorageActions(localStorage) {
        this.localStorage = localStorage;
    }
    SmartTableStorageActions.prototype.onPaginate = function (pager) {
        this.localStorage.$dispatch.emit({
            type: constants_1.Constants.ON_PAGINATED,
            payload: pager
        });
    };
    SmartTableStorageActions.prototype.onRowSelectionChange = function (rows) {
        this.localStorage.$dispatch.emit({
            type: constants_1.Constants.ON_ROW_SELECTION_CHANGE,
            payload: rows
        });
    };
    SmartTableStorageActions.prototype.onColumnSelectionChange = function (columns) {
        this.localStorage.$dispatch.emit({
            type: constants_1.Constants.ON_COLUMN_SELECTION_CHANGE,
            payload: columns
        });
    };
    SmartTableStorageActions.prototype.onColumnSort = function (sorts) {
        this.localStorage.$dispatch.emit({
            type: constants_1.Constants.ON_COLUMN_SORT,
            payload: sorts
        });
    };
    SmartTableStorageActions.prototype.onColumnSearch = function (searchParams) {
        this.localStorage.$dispatch.emit({
            type: constants_1.Constants.ON_COLUMN_SEARCH,
            payload: searchParams
        });
    };
    SmartTableStorageActions = __decorate([
        core_1.Injectable(), 
        __metadata('design:paramtypes', [local_storage_service_1.LocalStorageService])
    ], SmartTableStorageActions);
    return SmartTableStorageActions;
}());
exports.SmartTableStorageActions = SmartTableStorageActions;
//# sourceMappingURL=smart-table-storage.actions.js.map