"use strict";
var row_1 = require('./../smartTable/ng2-smart-table/lib/data-set/row');
var smart_table_action_params_model_1 = require('./../../model/actions/smart-table-action-params.model');
var smart_table_action_model_1 = require('./../../model/actions/smart-table-action.model');
var smart_table_actions_service_1 = require('./../../services/smart-table-actions.service');
var core_1 = require('@angular/core');
var core_2 = require('@angular/core');
var RowActionComponent = (function () {
    function RowActionComponent(actionService, changeDetectRef) {
        this.actionService = actionService;
        this.changeDetectRef = changeDetectRef;
        this.displayLength = true;
        this.optionsDisplayProperty = 'label';
        this.isSmartSelectorEnabled = true;
        this.selected = new core_2.EventEmitter();
        this.rowSelections = new Array();
    }
    RowActionComponent.prototype.onRowAction = function (event) {
        this.selected.emit(event);
    };
    RowActionComponent.prototype.ngOnInit = function () {
        var _this = this;
        this.actionService.onRowSelection().subscribe(function (rows) {
            _this.rowSelections = rows;
        });
        this.invokeActionValidFor();
    };
    RowActionComponent.prototype.invokeActionValidFor = function () {
        var _this = this;
        if (this.rowActionModel.$isActionValidForRequired) {
            var actionValidationParams = new smart_table_action_params_model_1.ActionValidationParams();
            actionValidationParams.rowSelections = [this.row];
            actionValidationParams.actionModel = this.rowActionModel;
            this.actionService.getActionValidForSource().next(actionValidationParams);
            this.actionService.onActionValidForResponse().subscribe(function (resp) {
                _this.rowActionModel.$actions = resp.actionModel.$actions;
                _this.changeDetectRef.markForCheck();
            });
        }
    };
    __decorate([
        core_2.Input(), 
        __metadata('design:type', Boolean)
    ], RowActionComponent.prototype, "displayLength", void 0);
    __decorate([
        core_2.Input(), 
        __metadata('design:type', smart_table_action_model_1.RowActionModel)
    ], RowActionComponent.prototype, "rowActionModel", void 0);
    __decorate([
        core_2.Input(), 
        __metadata('design:type', String)
    ], RowActionComponent.prototype, "optionsDisplayProperty", void 0);
    __decorate([
        core_2.Input(), 
        __metadata('design:type', Boolean)
    ], RowActionComponent.prototype, "isSmartSelectorEnabled", void 0);
    __decorate([
        core_2.Input(), 
        __metadata('design:type', row_1.Row)
    ], RowActionComponent.prototype, "row", void 0);
    __decorate([
        core_2.Output(), 
        __metadata('design:type', core_2.EventEmitter)
    ], RowActionComponent.prototype, "selected", void 0);
    __decorate([
        core_2.Input(), 
        __metadata('design:type', Array)
    ], RowActionComponent.prototype, "rowSelections", void 0);
    RowActionComponent = __decorate([
        core_2.Component({
            selector: 'row-action-component',
            template: "\n        <ng2-dropdown-comp label=\"Actions\" [displayLength]=\"false\" (selected)=\"onRowAction($event)\" class=\"row-action\"\n            optionsDisplayProperty=\"name\" [isSmartSelectorEnabled]=\"false\" [data]=\"rowActionModel | objectFilter: 'actions'\" >\n     </ng2-dropdown-comp>\n    ",
            styleUrls: ['./row-action-dropdown.css'],
            changeDetection: core_1.ChangeDetectionStrategy.OnPush,
        }), 
        __metadata('design:paramtypes', [smart_table_actions_service_1.SmartTableActionService, core_2.ChangeDetectorRef])
    ], RowActionComponent);
    return RowActionComponent;
}());
exports.RowActionComponent = RowActionComponent;
//# sourceMappingURL=row-action-dropdown.component.js.map