"use strict";
var object_utils_1 = require('./../../../../../utils/object-utils');
var cell_1 = require('./../../lib/data-set/cell');
var core_1 = require('@angular/core');
var CellComponent = (function () {
    function CellComponent(changeDetectRef) {
        this.changeDetectRef = changeDetectRef;
        this.inputClass = '';
        this.mode = 'inline';
        this.cellType = 'text';
        this.context = {};
        this.edited = new core_1.EventEmitter();
    }
    CellComponent.prototype.ngOnChanges = function (changes) {
        if (changes['cell']) {
            this.value = this.cell.getValue();
            this.determineCellType();
            if (object_utils_1.ObjectUtils.isNotNullAndUndefined(this.cell.type))
                this.type = this.cell.type + '-view';
            this.changeDetectRef.markForCheck();
        }
    };
    CellComponent.prototype.onStopEditing = function () {
        return false;
    };
    CellComponent.prototype.onEdited = function (event) {
        this.edited.emit(event);
        return false;
    };
    CellComponent.prototype.onClick = function (event) {
        event.stopPropagation();
    };
    CellComponent.prototype.determineCellType = function () {
        var viewTemplateUrl = this.cell.getViewTemplate();
        if (this.cell.isPopover) {
            this.cellType = 'popOver';
        }
        else if (object_utils_1.ObjectUtils.isNotNullAndUndefined(viewTemplateUrl)) {
            this.cellType = 'viewTemplate';
            this.templateHtml = this.cell.getViewTemplate();
            this.context = { contextValue: this.value };
        }
        else if (object_utils_1.ObjectUtils.isNotNullAndUndefined(this.cell.type)) {
            this.cellType = 'customType';
        }
        else {
            this.cellType = 'text';
        }
    };
    CellComponent.prototype.dynamicTemplateCallback = function (event) {
        this.changeDetectRef.markForCheck();
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', cell_1.Cell)
    ], CellComponent.prototype, "cell", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], CellComponent.prototype, "inputClass", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], CellComponent.prototype, "mode", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], CellComponent.prototype, "type", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], CellComponent.prototype, "edited", void 0);
    CellComponent = __decorate([
        core_1.Component({
            selector: 'ng2-smart-table-cell',
            moduleId: module.id,
            styleUrls: ['cell.css'],
            templateUrl: './cell.component.html',
            changeDetection: core_1.ChangeDetectionStrategy.OnPush
        }), 
        __metadata('design:paramtypes', [core_1.ChangeDetectorRef])
    ], CellComponent);
    return CellComponent;
}());
exports.CellComponent = CellComponent;
//# sourceMappingURL=cell.component.js.map