"use strict";
var constants_1 = require('./../../../../../../../utils/constants');
var Rx_1 = require('rxjs/Rx');
var core_1 = require('@angular/core');
var TextTemplate = (function () {
    function TextTemplate() {
        var _this = this;
        this.searched = new core_1.EventEmitter();
        this.debouncer = new Rx_1.Subject();
        this.debouncer.debounceTime(constants_1.Constants.SEARCH_DELAY_125).subscribe(function (searchedValue) { return _this.searched.emit(searchedValue); });
    }
    TextTemplate.prototype.onSearch = function (searchedValue) {
        this.debouncer.next(searchedValue);
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], TextTemplate.prototype, "type", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], TextTemplate.prototype, "title", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], TextTemplate.prototype, "value", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], TextTemplate.prototype, "id", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], TextTemplate.prototype, "searched", void 0);
    TextTemplate = __decorate([
        core_1.Component({
            selector: 'text-template',
            templateUrl: './text-template.component.html'
        }), 
        __metadata('design:paramtypes', [])
    ], TextTemplate);
    return TextTemplate;
}());
exports.TextTemplate = TextTemplate;
//# sourceMappingURL=text-template.component.js.map