"use strict";
var column_template_model_1 = require('./../../../../../model/templates/column-template.model');
var Column = (function () {
    function Column(id, settings, dataSet, uniqueTemplateMap) {
        this.id = id;
        this.settings = settings;
        this.dataSet = dataSet;
        this.attr = '';
        this.title = '';
        this.templateModel = new column_template_model_1.ColumnTemplateModel();
        this.class = '';
        this.list = [];
        this.isSortable = true;
        this.isEditable = true;
        this.isFilterable = false;
        this.isVisible = true;
        this.sortDirection = '';
        this.defaultSortDirection = '';
        if (this.settings) {
            this.applySettings();
        }
    }
    Column.prototype.getCompareFunction = function () {
        return this.compareFunction;
    };
    Column.prototype.getValuePrepareFunction = function () {
        return this.valuePrepareFunction;
    };
    Column.prototype.getFilterFunction = function () {
        return this.filterFunction;
    };
    Column.prototype.applySettings = function () {
        this.attr = this.settings['attr'];
        this.title = this.settings['title'];
        this.class = this.settings['class'];
        this.templateModel.$type = this.settings['type'];
        this.templateModel.$viewTemplate = this.settings['viewTemplate'];
        this.templateModel.$searchTemplate = this.settings['searchTemplate'];
        this.templateModel.$editTemplate = this.settings['editTemplate'];
        this.templateModel.$searchDescriptionTemplate = this.settings['searchDescriptionTemplate'];
        this.templateModel.$viewTemplateHtml = this.settings['viewTemplateHtml'];
        this.templateModel.$searchTemplateHtml = this.settings['searchTemplateHtml'];
        this.templateModel.$editTemplateHtml = this.settings['editTemplateHtml'];
        this.templateModel.$searchDescriptionTemplateHtml = this.settings['searchDescriptionTemplateHtml'];
        this.isFilterable = typeof this.settings['filter'] === 'undefined' ? true : !!this.settings['filter'];
        this.defaultSortDirection = ['st-multi-sort-ascent', 'st-multi-sort-descent'].indexOf(this.settings['sortDirection']) !== -1 ? this.settings['sortDirection'] : '';
        this.isSortable = (this.settings['sort'] === undefined || this.settings['sort'] === null) ? true : !!this.settings['sort'];
        this.isEditable = typeof this.settings['editable'] === 'undefined' ? true : !!this.settings['editable'];
        this.sortDirection = this.settings['sort'] === 'st-multi-sort-descent' ? 'st-multi-sort-descent' : 'st-multi-sort-ascent';
        this.compareFunction = this.settings['compareFunction'];
        this.valuePrepareFunction = this.settings['valuePrepareFunction'];
        this.filterFunction = this.settings['filterFunction'];
        this.isVisible = (this.settings['visible'] === undefined || this.settings['visible'] === null) ? true : this.settings['visible'];
        this.uniqueId = this.settings['uniqueId'] === 'undefined' ? this.title : this.settings['uniqueId'];
        this.list = this.settings['list'] === 'undefined' ? null : this.settings['list'];
    };
    return Column;
}());
exports.Column = Column;
//# sourceMappingURL=column.js.map