import { Column } from './column';
import { Row } from './row';
export declare class DataSet {
    protected columnSettings: Object;
    newRow: Row;
    protected data: Array<any>;
    private columns;
    protected rows: Array<Row>;
    protected selectedRows: Array<any>;
    protected selectedColumns: Array<any>;
    protected selectedRow: Row;
    constructor(data: Array<any>, columnSettings: Object);
    setSelectedRows(selectedRows: Array<any>): void;
    setSelectedColumns(selectedColumns: Array<any>): void;
    setData(data: Array<any>): void;
    getData(): Array<any>;
    getColumns(): Array<Column>;
    getRows(): Array<Row>;
    getSelectedRows(): Array<Row>;
    findRowByData(data: any): Row;
    deselectAll(): void;
    selectRow(row: Row): Row;
    selectPreviousRow(): Row;
    selectFirstRow(): Row;
    selectLastRow(): Row;
    select(): Row;
    createNewRow(): void;
    /**
     * Create columns by mapping from the settings
     * @param settings
     * @private
     */
    createColumns(settings: any): void;
    updateColumns(): void;
    updateRows(): void;
    /**
     * Create rows based on current data prepared in data source
     * @private
     */
    protected createRows(): void;
}
