"use strict";
var cell_1 = require('./cell');
var _ = require('underscore');
var Row = (function () {
    function Row(id, data, dataSet, selected) {
        this.id = id;
        this.data = data;
        this.dataSet = dataSet;
        this.isSelected = false;
        this.isQuickViewOpen = false;
        this.cells = new Array();
        this.isSelected = selected;
        this.createCells();
    }
    Row.prototype.createCells = function () {
        var _this = this;
        this.dataSet.getColumns().forEach(function (column) {
            if (column.isVisible) {
                var cell = _this.createCell(column);
                _this.cells.push(cell);
            }
        });
    };
    Row.prototype.createCell = function (column) {
        var value = '';
        var tempValue = '';
        if (column.id.indexOf('.') > -1) {
            var tempValue_1 = this.data;
            var columnProps = column.id.split('.');
            columnProps.forEach(function (prop) {
                tempValue_1 = tempValue_1[prop];
            });
            value = tempValue_1;
        }
        else if (typeof this.data[column.id] !== 'undefined') {
            value = this.data[column.id];
        }
        if (_.isArray(value)) {
            return new cell_1.Cell(value, this, column, this.dataSet, true);
        }
        else {
            return new cell_1.Cell(value, this, column, this.dataSet, false);
        }
    };
    Row.prototype.setSelected = function (selected) {
        this.isSelected = selected;
    };
    Row.prototype.getCell = function (column) {
        return this.cells.find(function (el) { return el.getColumn() === column; });
    };
    Row.prototype.getCells = function () {
        return this.cells;
    };
    Row.prototype.getData = function () {
        return this.data;
    };
    Row.prototype.getNewData = function () {
        var values = {};
        this.getCells().forEach(function (cell) { return values[cell.getColumn().id] = cell.newValue; });
        return Object.assign(this.data, values);
    };
    Row.prototype.setData = function (data) {
        this.data = data;
        this.createCells();
    };
    return Row;
}());
exports.Row = Row;
//# sourceMappingURL=row.js.map