import { Column } from './data-set/column';
import { DataSet } from './data-set/data-set';
import { Row } from './data-set/row';
import { DataSource } from './data-source/data-source';
import { EventEmitter } from '@angular/core';
import { Observable, Subject } from 'rxjs/Rx';
export declare class Grid {
    createFormShown: boolean;
    protected source: DataSource;
    protected settings: any;
    protected dataSet: DataSet;
    protected onSelectRowSource: Subject<any>;
    constructor(source: DataSource, settings: any);
    showActionColumn(): boolean;
    getNewRow(): Row;
    setSettings(settings: Object): void;
    updateSettings(settings: Object): void;
    getDataSet(): DataSet;
    getDataSource(): DataSource;
    setSource(source: DataSource): void;
    getSetting(name: string, defaultValue?: any): any;
    getColumns(): Array<Column>;
    getAllColumns(): Array<Column>;
    getRows(): Array<Row>;
    getSelectedRows(): Array<Row>;
    selectRow(row: Row): void;
    onSelectRow(): Observable<any>;
    create(row: Row, confirmEmitter: EventEmitter<any>): void;
    protected processDataChange(changes: any): void;
    protected shouldProcessChange(changes: any): boolean;
    protected determineRowToSelect(changes: any): Row;
    protected prepareSource(source: any): DataSource;
    protected getInitialSort(): {};
    getPreviousRow(currentRow: Row): Row;
    getRowIndex(row: Row): number;
    getNextRow(currentRow: Row): Row;
}
