"use strict";
var object_utils_1 = require('./../../../utils/object-utils');
var smart_table_rows_selections_model_1 = require('./../../../model/actions/smart-table-rows-selections.model');
var smart_table_action_model_1 = require('./../../../model/actions/smart-table-action.model');
var data_source_1 = require('./lib/data-source/data-source');
var local_data_source_1 = require('./lib/data-source/local/local.data-source');
var grid_1 = require('./lib/grid');
var helpers_1 = require('./lib/helpers');
var core_1 = require('@angular/core');
var Ng2SmartTableComponent = (function () {
    function Ng2SmartTableComponent(changeDetectRef) {
        this.changeDetectRef = changeDetectRef;
        this.rowSelect = new core_1.EventEmitter();
        this.userRowSelect = new core_1.EventEmitter();
        this.create = new core_1.EventEmitter();
        this.onSelectedRowAction = new core_1.EventEmitter();
        this.createConfirm = new core_1.EventEmitter();
        this.paginated = new core_1.EventEmitter();
        this.pagsChanged = new core_1.EventEmitter();
        this.rowSelectionChange = new core_1.EventEmitter();
        this.columnSelectionChange = new core_1.EventEmitter();
        this.sorted = new core_1.EventEmitter();
        this.searched = new core_1.EventEmitter();
        this.rowClicked = new core_1.EventEmitter();
        this.onPreviousEvent = new core_1.EventEmitter();
        this.onNextEvent = new core_1.EventEmitter();
        this.pagerData = { page: 1, perPage: 50 };
        this.defaultSettings = {
            hideHeader: false,
            hideSubHeader: false,
            selector: 'check',
            pageRows: [{ 'label': 10 }, { 'label': 15 }, { 'label': 25 }, { 'label': 50 }, { 'label': 100 }, { 'label': 1000 }],
            columns: {},
            pager: {
                display: true,
                perPage: 50
            }
        };
    }
    Ng2SmartTableComponent.prototype.getColumns = function () {
        return this.grid.getColumns();
    };
    Ng2SmartTableComponent.prototype.getRows = function () {
        return this.grid.getDataSet().getRows();
    };
    Ng2SmartTableComponent.prototype.getColSpanLength = function () {
        return this.getColumns().length + 1;
    };
    Ng2SmartTableComponent.prototype.getCells = function (row) {
        return row.getCells().filter(function (cell) {
            return cell.isVisible === true;
        });
    };
    ;
    Ng2SmartTableComponent.prototype.ngOnChanges = function (changes) {
        if (this.grid) {
            if (changes['settings']) {
                this.grid.updateSettings(this.prepareSettings());
            }
            if (changes['source']) {
                this.changeDetectRef.detach();
                var data = changes['source'].currentValue;
                if (this.dataSource && data.length > 0) {
                    console.log('changes[source]');
                    this.grid.getDataSource().load(data);
                    this.updateComponentFromState();
                }
                else {
                    this.dataSource = this.prepareSource();
                    this.grid.setSource(this.dataSource);
                }
            }
        }
        else {
            this.initGrid();
        }
    };
    Ng2SmartTableComponent.prototype.updateComponentFromState = function () {
        if (this.selectedPager && this.selectedPager.page && this.selectedPager.perPage) {
            this.grid.getDataSource().setPaging(this.selectedPager.page, this.selectedPager.perPage, false);
            this.pagerData.page = this.selectedPager.page;
            this.pagerData.perPage = this.selectedPager.perPage;
        }
        if (this.selectedSort && this.selectedSort.length > 0) {
            this.grid.getDataSource().setSort(this.selectedSort, false);
        }
        this.grid.getDataSet().setSelectedRows(this.selectedRows);
        this.grid.getDataSet().setSelectedColumns(this.selectedColumns);
        // this.changeDetectRef.markForCheck();
    };
    Ng2SmartTableComponent.prototype.onAdd = function (event) {
        event.stopPropagation();
        if (this.grid.getSetting('mode') === 'external') {
            this.create.emit({
                source: this.dataSource
            });
        }
        else {
            this.grid.createFormShown = true;
        }
        return false;
    };
    Ng2SmartTableComponent.prototype.onUserSelectRow = function (row) {
        this.grid.selectRow(row);
        this.userRowSelect.emit({
            data: row.getData(),
            source: this.dataSource
        });
        this.onSelectRow(row);
    };
    Ng2SmartTableComponent.prototype.onSelectRow = function (row) {
        this.grid.selectRow(row);
        this.rowSelect.emit({
            data: row.getData(),
            source: this.dataSource
        });
    };
    Ng2SmartTableComponent.prototype.onCreate = function (row, event) {
        event.stopPropagation();
        this.grid.create(row, this.createConfirm);
        return false;
    };
    Ng2SmartTableComponent.prototype.initGrid = function () {
        var _this = this;
        this.dataSource = this.prepareSource();
        this.dataSource.onChanged().subscribe(function (changes) {
            if (changes['elements'] && changes['elements'].length > 0) {
                console.log(changes.elements);
                _this.changeDetectRef.reattach();
            }
        });
        this.grid = new grid_1.Grid(this.dataSource, this.prepareSettings());
        this.grid.onSelectRow().subscribe(function (row) { return _this.onSelectRow(row); });
    };
    Ng2SmartTableComponent.prototype.prepareSource = function () {
        if (this.source instanceof data_source_1.DataSource) {
            return this.source;
        }
        else if (this.source instanceof Array) {
            return new local_data_source_1.LocalDataSource(this.source);
        }
        return new local_data_source_1.LocalDataSource();
    };
    Ng2SmartTableComponent.prototype.prepareSettings = function () {
        return helpers_1.deepExtend({}, this.defaultSettings, this.settings);
    };
    Ng2SmartTableComponent.prototype.onHeaderSelectAll = function (event) {
        this.onSelectAll(event.selectedValue);
        this.changeDetectRef.markForCheck();
    };
    Ng2SmartTableComponent.prototype.onSelectAll = function (selectedValue) {
        this.selectAll = selectedValue;
        this.updateRowSelections(selectedValue);
        this.rowSelectionChange.emit(this.grid.getSelectedRows());
        this.changeDetectRef.markForCheck();
    };
    Ng2SmartTableComponent.prototype.onRowSelection = function (event, row) {
        row.isSelected = event.selectedValue;
        this.rowSelectionChange.emit(this.grid.getSelectedRows());
        //this.changeDetectRef.markForCheck();
    };
    Ng2SmartTableComponent.prototype.updateRowSelections = function (selectedValue) {
        this.getRows().forEach(function (row) {
            row.isSelected = selectedValue;
        });
        this.changeDetectRef.markForCheck();
    };
    Ng2SmartTableComponent.prototype.onPaginate = function (event) {
        this.pagerData.page = event.page;
        this.pagerData.perPage = event.perPage;
        this.paginated.emit(this.pagerData);
        this.changeDetectRef.markForCheck();
    };
    // This is parent onColumnFilterChange, whih is a caller
    Ng2SmartTableComponent.prototype.onColumnFilterChange = function (event) {
        var _this = this;
        var passedColumn = event.selectedOption;
        var isColumnSelected = event.selectedValue;
        var columnsSelection = new Array();
        this.grid.getDataSet().getColumns().forEach(function (columnItem) {
            if (columnItem.uniqueId === passedColumn.uniqueId) {
                columnItem.isVisible = isColumnSelected;
                _this.handleRowsForColumnFilter(columnItem);
                return false;
            }
            columnsSelection.push(new smart_table_rows_selections_model_1.SmartTableSelectionData(columnItem.id, columnItem.isVisible));
        });
        this.columnSelectionChange.emit(this.grid.getAllColumns());
        this.changeDetectRef.markForCheck();
    };
    Ng2SmartTableComponent.prototype.handleRowsForColumnFilter = function (columnItem) {
        this.grid.getDataSet().getRows().forEach(function (rowItem) {
            rowItem.getCells().forEach(function (cell) {
                if (cell.getColumn().uniqueId === columnItem.uniqueId) {
                    cell.isVisible = columnItem.isVisible;
                    return true;
                }
            });
        });
    };
    Ng2SmartTableComponent.prototype.onPageSizeChange = function (event) {
        var perPage = event.selectedPage;
        this.pagerData.perPage = perPage;
        this.dataSource.setPaging(1, perPage, true);
        this.pagsChanged.emit(this.pagerData);
    };
    Ng2SmartTableComponent.prototype.onColumnSort = function (sorts) {
        this.sorted.emit(sorts);
        this.changeDetectRef.markForCheck();
    };
    Ng2SmartTableComponent.prototype.onRowAction = function (event, selectedRow) {
        event.selectedRow = selectedRow;
        this.onSelectedRowAction.emit(event);
        this.changeDetectRef.markForCheck();
    };
    Ng2SmartTableComponent.prototype.onRowClick = function (event, row) {
        this.rowClicked.emit(row);
        if (event.srcElement.nodeName != 'INPUT') {
            this.getRows().forEach(function (innerRow) {
                if (row.id === innerRow.id) {
                    innerRow.isQuickViewOpen = true;
                }
                else {
                    innerRow.isQuickViewOpen = false;
                }
            });
        }
    };
    Ng2SmartTableComponent.prototype.onNext = function (row) {
        row.isQuickViewOpen = false;
        var previousRow = this.grid.getNextRow(row);
        if (object_utils_1.ObjectUtils.isNotNullAndUndefined(previousRow)) {
            previousRow.isQuickViewOpen = true;
        }
        else {
            this.onNextEvent.emit(row);
        }
    };
    Ng2SmartTableComponent.prototype.onPrevious = function (row) {
        row.isQuickViewOpen = false;
        var nextRow = this.grid.getPreviousRow(row);
        if (object_utils_1.ObjectUtils.isNotNullAndUndefined(nextRow)) {
            nextRow.isQuickViewOpen = true;
        }
        else {
            this.onNextEvent.emit(row);
        }
    };
    Ng2SmartTableComponent.prototype.onQuickViewClose = function (row) {
        var rowIndex = this.grid.getRowIndex(row);
        this.grid.getRows()[rowIndex].isQuickViewOpen = false;
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], Ng2SmartTableComponent.prototype, "source", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], Ng2SmartTableComponent.prototype, "settings", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], Ng2SmartTableComponent.prototype, "selectAll", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], Ng2SmartTableComponent.prototype, "selectedRows", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], Ng2SmartTableComponent.prototype, "selectedColumns", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], Ng2SmartTableComponent.prototype, "selectedPager", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Array)
    ], Ng2SmartTableComponent.prototype, "selectedSort", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', smart_table_action_model_1.RowActionModel)
    ], Ng2SmartTableComponent.prototype, "rowActionModel", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], Ng2SmartTableComponent.prototype, "rowSelect", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], Ng2SmartTableComponent.prototype, "userRowSelect", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], Ng2SmartTableComponent.prototype, "create", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], Ng2SmartTableComponent.prototype, "onSelectedRowAction", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], Ng2SmartTableComponent.prototype, "createConfirm", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], Ng2SmartTableComponent.prototype, "paginated", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], Ng2SmartTableComponent.prototype, "pagsChanged", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], Ng2SmartTableComponent.prototype, "rowSelectionChange", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], Ng2SmartTableComponent.prototype, "columnSelectionChange", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], Ng2SmartTableComponent.prototype, "sorted", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], Ng2SmartTableComponent.prototype, "searched", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], Ng2SmartTableComponent.prototype, "rowClicked", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], Ng2SmartTableComponent.prototype, "onPreviousEvent", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], Ng2SmartTableComponent.prototype, "onNextEvent", void 0);
    Ng2SmartTableComponent = __decorate([
        core_1.Component({
            selector: 'ng2-smart-table',
            moduleId: module.id,
            styleUrls: ['./ng2-smart-table.scss'],
            templateUrl: 'ng2-smart-table.html',
            changeDetection: core_1.ChangeDetectionStrategy.OnPush
        }), 
        __metadata('design:paramtypes', [core_1.ChangeDetectorRef])
    ], Ng2SmartTableComponent);
    return Ng2SmartTableComponent;
}());
exports.Ng2SmartTableComponent = Ng2SmartTableComponent;
//# sourceMappingURL=ng2-smart-table.component.js.map