"use strict";
var object_utils_1 = require('./../utils/object-utils');
var MoneyTemplateModel = (function () {
    function MoneyTemplateModel(newRange) {
        if (newRange === void 0) { newRange = null; }
        this.newRange = newRange;
        this.range = new Range();
        if (object_utils_1.ObjectUtils.isNotNullAndUndefined(newRange))
            this.$range = newRange;
        else
            this.range = new Range();
    }
    Object.defineProperty(MoneyTemplateModel.prototype, "$range", {
        get: function () {
            return this.range;
        },
        set: function (value) {
            this.range = value;
        },
        enumerable: true,
        configurable: true
    });
    return MoneyTemplateModel;
}());
exports.MoneyTemplateModel = MoneyTemplateModel;
var Range = (function () {
    function Range(lowValue, highValue) {
        if (lowValue === void 0) { lowValue = null; }
        if (highValue === void 0) { highValue = null; }
        this.lowValue = lowValue;
        this.highValue = highValue;
        this.$high = highValue;
        this.$low = lowValue;
    }
    Object.defineProperty(Range.prototype, "$low", {
        get: function () {
            return this.low;
        },
        set: function (value) {
            this.low = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Range.prototype, "$high", {
        get: function () {
            return this.high;
        },
        set: function (value) {
            this.high = value;
        },
        enumerable: true,
        configurable: true
    });
    Range.isHighAlone = function (value) {
        return object_utils_1.ObjectUtils.isNotNullAndUndefined(value.$high) && object_utils_1.ObjectUtils.isNullOrUndefined(value.$low);
    };
    Range.isLowAlone = function (value) {
        return object_utils_1.ObjectUtils.isNotNullAndUndefined(value.$low) && object_utils_1.ObjectUtils.isNullOrUndefined(value.$high);
    };
    Range.isHighAndLowAvailable = function (value) {
        return object_utils_1.ObjectUtils.isNotNullAndUndefined(value.$high) && object_utils_1.ObjectUtils.isNotNullAndUndefined(value.$low);
    };
    return Range;
}());
exports.Range = Range;
//# sourceMappingURL=money-template.model.js.map