import { BaseHttpService } from './../base-http.service';
import { JwtAuthHelper } from './jwt-auth-helper';
import { JwtTokenUrlService } from './jwt-token-url.service';
import { Http } from '@angular/http';
import { AuthHttp } from 'angular2-jwt';
import { Subject } from 'rxjs/Rx';
export declare class JwtAuthConfiguration {
    private http;
    private baseHttp;
    private tokenUrl;
    private adjJWtHelper;
    url: string;
    constructor(http: Http, baseHttp: BaseHttpService, tokenUrl: JwtTokenUrlService, adjJWtHelper: JwtAuthHelper);
    makeAuthHttpReady(authHttpSource: Subject<AuthHttp>): void;
    private logDelta(token);
    private tokenNeedsToBeRefreshed(token);
    private refreshToken(token, authHttpSource);
    private getObservableForToken();
    private static setToken(response, authTokenSource);
    private logToken(token);
    private createAuthHttp(token, authHttpSource);
    private getNewAuthHttp(token);
}
