"use strict";
var jwt_auth_configuration_1 = require('./jwt-auth-configuration');
var core_1 = require('@angular/core');
var http_1 = require('@angular/http');
var Observable_1 = require('rxjs/Observable');
var Rx_1 = require('rxjs/Rx');
var configuration_service_1 = require("../configuration/configuration.service");
var _ = require('underscore');
var JwtRestService = (function () {
    function JwtRestService(jwtConfig, config) {
        this.jwtConfig = jwtConfig;
        this.config = config;
        this.invoke = function invoke(url, params) {
            var _this = this;
            if (params === void 0) { params = null; }
            var adjudicationRestSource = new Rx_1.Subject();
            var adjudicationRest$ = adjudicationRestSource.asObservable();
            var authHttpSource = new Rx_1.Subject();
            var authHttpSource$ = authHttpSource.asObservable();
            authHttpSource$.subscribe(function (authHttp) {
                var uri = _this.config.baseRestUrl + url;
                var urlParams = new http_1.URLSearchParams();
                var options = new http_1.RequestOptions({ search: urlParams });
                if (params) {
                    _.mapObject(params, function (value, key) {
                        urlParams.set(key, value);
                    });
                }
                authHttp.request(uri, options).subscribe(function (resp) {
                    adjudicationRestSource.next(resp.json());
                    adjudicationRestSource.complete();
                });
            }, function (error) {
                _this.handleError(error);
            }, function () { return console.log(" AdjudicationRestService invoke call is Completed !!!"); });
            this.jwtAuthConfiguration.makeAuthHttpReady(authHttpSource);
            return adjudicationRest$;
        };
        this.jwtAuthConfiguration = jwtConfig;
    }
    JwtRestService.prototype.handleError = function (error) {
        console.error(error);
        return Observable_1.Observable.throw(error || 'Server error');
    };
    JwtRestService = __decorate([
        core_1.Injectable(), 
        __metadata('design:paramtypes', [jwt_auth_configuration_1.JwtAuthConfiguration, configuration_service_1.ConfigurationService])
    ], JwtRestService);
    return JwtRestService;
}());
exports.JwtRestService = JwtRestService;
//# sourceMappingURL=jwt-rest.service.js.map