"use strict";
var configuration_service_1 = require('./../configuration/configuration.service');
var core_1 = require('@angular/core');
// created by Raghavendra Chinam
var JwtTokenUrlService = (function () {
    function JwtTokenUrlService(config) {
        this.config = config;
        this.getJWTServletUrl = function getJWTServletUrl() {
            // Prefer baseAppUrl if we are in an IFrame.
            if (window.top && window.top['baseAppUrl']) {
                return window.top.top['baseAppUrl'] + "/jwt";
            }
            else {
                // Fall back to the configured URL on the
                return this.config.jwtBaseUrl + "/jwt";
            }
        };
    }
    JwtTokenUrlService = __decorate([
        core_1.Injectable(), 
        __metadata('design:paramtypes', [configuration_service_1.ConfigurationService])
    ], JwtTokenUrlService);
    return JwtTokenUrlService;
}());
exports.JwtTokenUrlService = JwtTokenUrlService;
//# sourceMappingURL=jwt-token-url.service.js.map