import { NgZone, OnDestroy, EventEmitter } from '@angular/core';
import { Reducer } from 'redux';
import { Observable } from 'rxjs/Rx';
export declare type PropertySelector = string | number | symbol;
export declare type PathSelector = (string | number)[];
export declare type Comparator = (x: any, y: any) => boolean;
export declare class LocalStorageService implements OnDestroy {
    private ngZone;
    private dispatch;
    private stateSource;
    private store;
    private storeUnSubscribe;
    private state;
    private _selectSource;
    private storeKey;
    static INSTANCE: any;
    constructor(ngZone: NgZone);
    createStorage(initialState: Object, rootReducers: Reducer<any>, key?: string): void;
    private createReduxStoreAndSaveState(reducers, initialState?);
    private getStateFromLocalStorage(key);
    updateKey(key: string): void;
    private updateState(key);
    select<T>(selector: PropertySelector | PathSelector, comparator?: Comparator): Observable<any>;
    makeAsyncDispatch(dispatchParam: {
        type: string;
        payload: any;
    }): any;
    readonly $dispatch: EventEmitter<any>;
    ngOnDestroy(): void;
}
