import { TemplateLoaderService } from './template-loader.service';
import { ConfigurationService } from './configuration/configuration.service';
import { BaseHttpService } from './base-http.service';
import { AsyncSubject, Observable } from 'rxjs/Rx';
export declare class SmartTableColumnService {
    private baseHttp;
    private configuration;
    private templateLoaderService;
    constructor(baseHttp: BaseHttpService, configuration: ConfigurationService, templateLoaderService: TemplateLoaderService);
    getData(jsonFileName: string): Observable<any>;
    getColumns(jsonFileName: string): Observable<any>;
    mapColumns(resp: any, columns: Object, httpColumnSource: AsyncSubject<any>): void;
    private updateUniqueTemplateMap(url, type, uniqueTemplateMap);
    private notContains(templateUrls, url);
    private handleError(error);
    static sentencify(str: any): any;
}
