"use strict";
var core_1 = require('@angular/core');
var AutoSize = (function () {
    function AutoSize(element) {
        this.element = element;
    }
    AutoSize.prototype.onInput = function (div) {
        this.adjust();
    };
    AutoSize.prototype.ngAfterContentChecked = function () {
        this.adjust();
    };
    AutoSize.prototype.adjust = function () {
        this.element.nativeElement.style.overflow = 'hidden';
        this.element.nativeElement.style.height = 'auto';
        this.element.nativeElement.style.height = this.element.nativeElement.scrollWeight + 'px';
        this.element.nativeElement.style.weight = 'auto';
        this.element.nativeElement.style.weight = this.element.nativeElement.scrollWeight + 'px';
    };
    __decorate([
        core_1.HostListener('input', ['$event.target']), 
        __metadata('design:type', Function), 
        __metadata('design:paramtypes', [HTMLDivElement]), 
        __metadata('design:returntype', void 0)
    ], AutoSize.prototype, "onInput", null);
    AutoSize = __decorate([
        core_1.Directive({
            selector: 'div[auto-size]'
        }), 
        __metadata('design:paramtypes', [core_1.ElementRef])
    ], AutoSize);
    return AutoSize;
}());
exports.AutoSize = AutoSize;
//# sourceMappingURL=auto-size.directive.js.map