"use strict";
var ng2_redux_1 = require('ng2-redux');
var constants_1 = require('./../../utils/constants');
var core_1 = require('@angular/core');
var SmartTableStorageActions = (function () {
    function SmartTableStorageActions(ngRedux) {
        this.ngRedux = ngRedux;
    }
    SmartTableStorageActions.prototype.onPaginate = function (pager) {
        this.ngRedux.dispatch({
            type: constants_1.Constants.ON_PAGINATED,
            payload: pager
        });
    };
    SmartTableStorageActions.prototype.onRowSelectionChange = function (rows) {
        this.ngRedux.dispatch({
            type: constants_1.Constants.ON_ROW_SELECTION_CHANGE,
            payload: rows
        });
    };
    SmartTableStorageActions.prototype.onColumnSelectionChange = function (columns) {
        this.ngRedux.dispatch({
            type: constants_1.Constants.ON_COLUMN_SELECTION_CHANGE,
            payload: columns
        });
    };
    SmartTableStorageActions.prototype.onColumnSort = function (sorts) {
        this.ngRedux.dispatch({
            type: constants_1.Constants.ON_COLUMN_SORT,
            payload: sorts
        });
    };
    SmartTableStorageActions.prototype.onColumnSearch = function (searchParams) {
        this.ngRedux.dispatch({
            type: constants_1.Constants.ON_COLUMN_SEARCH,
            payload: searchParams
        });
    };
    SmartTableStorageActions = __decorate([
        core_1.Injectable(), 
        __metadata('design:paramtypes', [ng2_redux_1.NgRedux])
    ], SmartTableStorageActions);
    return SmartTableStorageActions;
}());
exports.SmartTableStorageActions = SmartTableStorageActions;
//# sourceMappingURL=smart-table-storage.actions.js.map