"use strict";
var smart_table_actions_service_1 = require('../../services/smart-table-actions.service');
var smart_table_action_params_model_1 = require('./../../model/actions/smart-table-action-params.model');
var smart_table_action_model_1 = require('./../../model/actions/smart-table-action.model');
var object_utils_1 = require('./../../utils/object-utils');
var core_1 = require('@angular/core');
var UiBulkActionComponent = (function () {
    function UiBulkActionComponent(actionService, changeDetectRef) {
        this.actionService = actionService;
        this.changeDetectRef = changeDetectRef;
        this.label = 'Bulk Actions';
        this.rowSelections = new Array();
        this.optionsDisplayProperty = 'label';
        this.selected = new core_1.EventEmitter();
    }
    UiBulkActionComponent.prototype.ngOnInit = function () {
        var _this = this;
        this.actionService.onRowSelection().subscribe(function (rows) {
            _this.rowSelections = rows;
            _this.changeDetectRef.markForCheck();
            if (_this.bulkActionModel.$isActionValidForAllRequired) {
                var actionValidationParams = new smart_table_action_params_model_1.ActionValidationParams();
                actionValidationParams.actionModel = _this.bulkActionModel;
                actionValidationParams.rowSelections = _this.rowSelections;
                _this.actionService.getActionValidForAllSource().next(actionValidationParams);
            }
        });
        this.actionService.onActionValidForAllResponse().subscribe(function (resp) {
            if (resp.actionModel instanceof smart_table_action_model_1.BulkActionModel) {
                _this.bulkActionModel.$actions = resp.actionModel.$actions;
                _this.changeDetectRef.markForCheck();
            }
        });
    };
    UiBulkActionComponent.prototype.onSelect = function (event, selectedOption) {
        if (object_utils_1.ObjectUtils.isNullOrUndefined(this.label)) {
            this.displayValue = selectedOption.label;
        }
        event.selectedOption = selectedOption;
        event.rowSelections = this.rowSelections;
        this.selected.emit(event);
    };
    ;
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], UiBulkActionComponent.prototype, "label", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', smart_table_action_model_1.BulkActionModel)
    ], UiBulkActionComponent.prototype, "bulkActionModel", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], UiBulkActionComponent.prototype, "context", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], UiBulkActionComponent.prototype, "menuId", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Array)
    ], UiBulkActionComponent.prototype, "rowSelections", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], UiBulkActionComponent.prototype, "toolTip", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], UiBulkActionComponent.prototype, "optionsDisplayProperty", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], UiBulkActionComponent.prototype, "selected", void 0);
    UiBulkActionComponent = __decorate([
        core_1.Component({
            selector: 'ui-bulk-action-component',
            templateUrl: './bulk-action-dropdown.component.html',
            styleUrls: ['./bulk-action-dropdown.css'],
            changeDetection: core_1.ChangeDetectionStrategy.OnPush
        }), 
        __metadata('design:paramtypes', [smart_table_actions_service_1.SmartTableActionService, core_1.ChangeDetectorRef])
    ], UiBulkActionComponent);
    return UiBulkActionComponent;
}());
exports.UiBulkActionComponent = UiBulkActionComponent;
//# sourceMappingURL=bulk-action-dropdown.component.js.map