"use strict";
var column_1 = require('./../../../lib/data-set/column');
var core_1 = require('@angular/core');
var CellTemplate = (function () {
    function CellTemplate() {
        this.searched = new core_1.EventEmitter();
    }
    CellTemplate.prototype.onColumnSearch = function (searchValue) {
        this.searched.emit(searchValue);
    };
    CellTemplate.prototype.ngOnChanges = function (changes) {
        if (changes['type'] && this.type) {
            if (this.type.indexOf('-') > -1) {
                this.templateType = this.type.substring(0, this.type.indexOf('-'));
            }
            else {
                this.templateType = this.type;
            }
        }
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], CellTemplate.prototype, "componentType", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], CellTemplate.prototype, "cellData", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], CellTemplate.prototype, "title", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], CellTemplate.prototype, "type", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', column_1.Column)
    ], CellTemplate.prototype, "column", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], CellTemplate.prototype, "searched", void 0);
    CellTemplate = __decorate([
        core_1.Component({
            selector: 'cell-template',
            templateUrl: './cell-template.component.html'
        }), 
        __metadata('design:paramtypes', [])
    ], CellTemplate);
    return CellTemplate;
}());
exports.CellTemplate = CellTemplate;
//# sourceMappingURL=cell-template.component.js.map