"use strict";
var object_utils_1 = require('./../../../../../../../utils/object-utils');
var column_1 = require('./../../../../lib/data-set/column');
var core_1 = require('@angular/core');
var comma_separated_list_pipe_1 = require('./../../../../../../../utils/comma-separated-list.pipe');
var _ = require('underscore');
var ListTemplate = (function () {
    function ListTemplate() {
        this.searched = new core_1.EventEmitter();
    }
    ListTemplate.prototype.onSearch = function (searchedValue) {
        this.searched.emit(searchedValue.value);
    };
    ListTemplate.prototype.ngOnChanges = function (changes) {
        if (changes['column'] && this.column && _.size(this.column.list) > 0) {
            if (typeof this.column.list[0] === 'string' || Number) {
                this.data = object_utils_1.ObjectUtils.getArrayOfObjects(this.column.list);
            }
        }
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], ListTemplate.prototype, "type", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', column_1.Column)
    ], ListTemplate.prototype, "column", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], ListTemplate.prototype, "uniqueid", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], ListTemplate.prototype, "value", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], ListTemplate.prototype, "searched", void 0);
    ListTemplate = __decorate([
        core_1.Component({
            selector: 'list-template',
            moduleId: module.id,
            templateUrl: './list-template.component.html',
            providers: [comma_separated_list_pipe_1.CommaSeparatedList]
        }), 
        __metadata('design:paramtypes', [])
    ], ListTemplate);
    return ListTemplate;
}());
exports.ListTemplate = ListTemplate;
//# sourceMappingURL=list-template.component.js.map