"use strict";
var constants_1 = require('../../../../../../../utils/constants');
var money_template_model_1 = require('./../../../../../../../model/money-template.model');
var currency_format_pipe_1 = require('./../../../../../../../utils/currency-format.pipe');
var core_1 = require('@angular/core');
var Rx_1 = require('rxjs/Rx');
var MoneyTemplate = (function () {
    function MoneyTemplate() {
        var _this = this;
        this.searched = new core_1.EventEmitter();
        this.debouncer = new Rx_1.Subject();
        this.range = new money_template_model_1.Range();
        this.debouncer.debounceTime(constants_1.Constants.SEARCH_DELAY_125).subscribe(function (money) { return _this.searched.emit(money); });
    }
    MoneyTemplate.prototype.isHighAlone = function () {
        return money_template_model_1.Range.isHighAlone(this.value);
    };
    MoneyTemplate.prototype.isLowAlone = function () {
        return money_template_model_1.Range.isLowAlone(this.value);
    };
    MoneyTemplate.prototype.isHighAndLowAvailable = function () {
        return money_template_model_1.Range.isHighAndLowAvailable(this.value);
    };
    MoneyTemplate.prototype.onSearch = function (event) {
        var newRange = new money_template_model_1.Range(this.range.$low, this.range.$high);
        this.debouncer.next(newRange);
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], MoneyTemplate.prototype, "type", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], MoneyTemplate.prototype, "title", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', money_template_model_1.Range)
    ], MoneyTemplate.prototype, "value", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', money_template_model_1.Range)
    ], MoneyTemplate.prototype, "range", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], MoneyTemplate.prototype, "uniqueId", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], MoneyTemplate.prototype, "searched", void 0);
    MoneyTemplate = __decorate([
        core_1.Component({
            selector: 'money-template',
            templateUrl: './money-template.component.html',
            providers: [currency_format_pipe_1.CurrencyFormatPipe]
        }), 
        __metadata('design:paramtypes', [])
    ], MoneyTemplate);
    return MoneyTemplate;
}());
exports.MoneyTemplate = MoneyTemplate;
//# sourceMappingURL=money-template.component.js.map