"use strict";
var name_template_model_1 = require('../../../../../../../model/name-template.model');
var constants_1 = require('./../../../../../../../utils/constants');
var core_1 = require('@angular/core');
var Rx_1 = require('rxjs/Rx');
var NameTemplate = (function () {
    function NameTemplate(changeDetectRef) {
        var _this = this;
        this.changeDetectRef = changeDetectRef;
        this.searched = new core_1.EventEmitter();
        this.debouncer = new Rx_1.Subject();
        this.name = new name_template_model_1.NameTemplateModel();
        this.debouncer.debounceTime(constants_1.Constants.SEARCH_DELAY_125).subscribe(function (newName) { return _this.searched.emit(newName); });
    }
    NameTemplate.prototype.ngOnChanges = function (changes) {
        if (changes['value']) {
            this.changeDetectRef.markForCheck();
        }
    };
    NameTemplate.prototype.onSearch = function (event) {
        var newNameModel = new name_template_model_1.NameTemplateModel(this.name.$first, this.name.$middle, this.name.$last);
        this.debouncer.next(newNameModel);
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NameTemplate.prototype, "type", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NameTemplate.prototype, "title", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NameTemplate.prototype, "value", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NameTemplate.prototype, "uniqueId", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', name_template_model_1.NameTemplateModel)
    ], NameTemplate.prototype, "name", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NameTemplate.prototype, "column", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], NameTemplate.prototype, "searched", void 0);
    NameTemplate = __decorate([
        core_1.Component({
            selector: 'name-template',
            templateUrl: './name-template.component.html',
            styleUrls: ['./name-template.css'],
            changeDetection: core_1.ChangeDetectionStrategy.OnPush
        }), 
        __metadata('design:paramtypes', [core_1.ChangeDetectorRef])
    ], NameTemplate);
    return NameTemplate;
}());
exports.NameTemplate = NameTemplate;
//# sourceMappingURL=name-template.component.js.map