"use strict";
var constants_1 = require('./../../../../../../../utils/constants');
var Rx_1 = require('rxjs/Rx');
var core_1 = require('@angular/core');
var NumericTemplate = (function () {
    function NumericTemplate() {
        var _this = this;
        this.searched = new core_1.EventEmitter();
        this.debouncer = new Rx_1.Subject();
        this.debouncer.debounceTime(constants_1.Constants.SEARCH_DELAY_125).subscribe(function (searchedValue) { return _this.searched.emit(searchedValue); });
    }
    NumericTemplate.prototype.onSearch = function (searchedValue) {
        this.debouncer.next(new Object(searchedValue));
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NumericTemplate.prototype, "type", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NumericTemplate.prototype, "title", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NumericTemplate.prototype, "value", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NumericTemplate.prototype, "uniqueId", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], NumericTemplate.prototype, "searched", void 0);
    NumericTemplate = __decorate([
        core_1.Component({
            selector: 'numeric-template',
            templateUrl: './numeric-template.component.html'
        }), 
        __metadata('design:paramtypes', [])
    ], NumericTemplate);
    return NumericTemplate;
}());
exports.NumericTemplate = NumericTemplate;
//# sourceMappingURL=numeric-template.component.js.map