"use strict";
var money_template_model_1 = require('./../../../../../../../model/money-template.model');
var Rx_1 = require('rxjs/Rx');
var core_1 = require('@angular/core');
var RangeTemplate = (function () {
    function RangeTemplate() {
        this.range = new money_template_model_1.Range();
        this.debouncer = new Rx_1.Subject();
    }
    RangeTemplate.prototype.isHighAlone = function () {
        return money_template_model_1.Range.isHighAlone(this.value);
    };
    RangeTemplate.prototype.isLowAlone = function () {
        return money_template_model_1.Range.isLowAlone(this.value);
    };
    RangeTemplate.prototype.isHighAndLowAvailable = function () {
        return money_template_model_1.Range.isHighAndLowAvailable(this.value);
    };
    RangeTemplate.prototype.onSearch = function (event) {
        var newRange = new money_template_model_1.Range(this.range.$low, this.range.$high);
        this.debouncer.next(newRange);
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], RangeTemplate.prototype, "type", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], RangeTemplate.prototype, "title", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', money_template_model_1.Range)
    ], RangeTemplate.prototype, "value", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], RangeTemplate.prototype, "uniqueId", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', money_template_model_1.Range)
    ], RangeTemplate.prototype, "range", void 0);
    RangeTemplate = __decorate([
        core_1.Component({
            selector: 'range-template',
            templateUrl: 'range-template.component.html'
        }), 
        __metadata('design:paramtypes', [])
    ], RangeTemplate);
    return RangeTemplate;
}());
exports.RangeTemplate = RangeTemplate;
//# sourceMappingURL=range-template.component.js.map