"use strict";
var data_source_1 = require('../../lib/data-source/data-source');
var core_1 = require('@angular/core');
var core_2 = require('@angular/core');
var PagerComponent = (function () {
    function PagerComponent(changeDetector) {
        this.changeDetector = changeDetector;
        this.paginated = new core_2.EventEmitter();
        this.count = 0;
    }
    /*  ngOnChanges(changes:{ [propertyName: string]: SimpleChange }):void {
          if (this.source && changes['source']) {
              this.source.onChanged().subscribe((changes) => {
                  this.page = this.source.getPaging().page;
                  this.count = this.source.count();
                  this.perPage = this.source.getPaging().perPage;
  
                  if (this.isPageOutOfBounce()) {
                      this.source.setPage(--this.page);
                  }
  
                  this.processPageChange(changes);
                  this.initPages();
              });
          }
  
      } */
    PagerComponent.prototype.ngOnInit = function () {
        var _this = this;
        this.source.onChanged().subscribe(function (changes) {
            if (changes['elements'] && changes['elements'].length > 0) {
                console.log(changes);
                _this.page = _this.source.getPaging().page;
                _this.count = _this.source.count();
                _this.perPage = _this.source.getPaging().perPage;
                if (_this.isPageOutOfBounce()) {
                    _this.source.setPage(--_this.page);
                }
                _this.processPageChange(changes);
                _this.initPages();
                _this.changeDetector.markForCheck();
            }
        });
    };
    /**
     * We change the page here depending on the action performed against data source
     * if a new element was added to the end of the table - then change the page to the last
     * if a new element was added to the beginning of the table - then to the first page
     * @param changes
     */
    PagerComponent.prototype.processPageChange = function (changes) {
        if (changes['action'] === 'prepend') {
            this.source.setPage(1);
        }
        if (changes['action'] === 'append') {
            this.source.setPage(this.getLast());
        }
    };
    PagerComponent.prototype.shouldShow = function () {
        return this.source && this.source.count() > this.perPage;
    };
    PagerComponent.prototype.paginate = function (page) {
        this.source.setPage(page);
        this.page = page;
        this.paginated.emit(this);
        return false;
    };
    PagerComponent.prototype.getPage = function () {
        return this.page;
    };
    PagerComponent.prototype.getPages = function () {
        return this.pages;
    };
    PagerComponent.prototype.getLast = function () {
        return Math.ceil(this.count / this.perPage);
    };
    PagerComponent.prototype.isPageOutOfBounce = function () {
        return (this.page * this.perPage) >= (this.count + this.perPage) && this.page > 1;
    };
    PagerComponent.prototype.initPages = function () {
        var pagesCount = this.getLast();
        var showPagesCount = 4;
        showPagesCount = pagesCount < showPagesCount ? pagesCount : showPagesCount;
        this.pages = [];
        if (this.shouldShow()) {
            var middleOne = Math.ceil(showPagesCount / 2);
            middleOne = this.page >= middleOne ? this.page : middleOne;
            var lastOne = middleOne + Math.floor(showPagesCount / 2);
            lastOne = lastOne >= pagesCount ? pagesCount : lastOne;
            var firstOne = lastOne - showPagesCount + 1;
            for (var i = firstOne; i <= lastOne; i++) {
                this.pages.push(i);
            }
        }
    };
    __decorate([
        core_2.Input(), 
        __metadata('design:type', Number)
    ], PagerComponent.prototype, "perPage", void 0);
    __decorate([
        core_2.Input(), 
        __metadata('design:type', data_source_1.DataSource)
    ], PagerComponent.prototype, "source", void 0);
    __decorate([
        core_2.Output(), 
        __metadata('design:type', core_2.EventEmitter)
    ], PagerComponent.prototype, "paginated", void 0);
    PagerComponent = __decorate([
        core_2.Component({
            selector: 'ng2-smart-table-pager',
            moduleId: module.id,
            templateUrl: './pager.component.html',
            changeDetection: core_1.ChangeDetectionStrategy.OnPush
        }), 
        __metadata('design:paramtypes', [core_1.ChangeDetectorRef])
    ], PagerComponent);
    return PagerComponent;
}());
exports.PagerComponent = PagerComponent;
//# sourceMappingURL=pager.component.js.map