"use strict";
var smart_table_action_model_1 = require('./../../../../../model/actions/smart-table-action.model');
var grid_1 = require('./../../lib/grid');
var core_1 = require('@angular/core');
var RowComponent = (function () {
    function RowComponent() {
        this.rowSelectionChange = new core_1.EventEmitter();
        this.onSelectedRowAction = new core_1.EventEmitter();
    }
    RowComponent.prototype.onRowSelection = function (event, row) {
        row.isSelected = event.selectedValue;
        this.rowSelectionChange.emit(this.grid.getSelectedRows());
    };
    RowComponent.prototype.onRowAction = function (event, selectedRow) {
        event.selectedRow = selectedRow;
        this.onSelectedRowAction.emit(event);
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', grid_1.Grid)
    ], RowComponent.prototype, "grid", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', smart_table_action_model_1.RowActionModel)
    ], RowComponent.prototype, "rowActionModel", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], RowComponent.prototype, "rowSelectionChange", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], RowComponent.prototype, "onSelectedRowAction", void 0);
    RowComponent = __decorate([
        core_1.Component({
            selector: 'row-component',
            templateUrl: './row.component.html',
            styleUrls: ['./row.component.css'],
            changeDetection: core_1.ChangeDetectionStrategy.Default
        }), 
        __metadata('design:paramtypes', [])
    ], RowComponent);
    return RowComponent;
}());
exports.RowComponent = RowComponent;
//# sourceMappingURL=row.component.js.map