"use strict";
var smart_table_search_1 = require('./../../../services/smart-table-search');
var object_utils_1 = require('./../../../../../utils/object-utils');
var column_1 = require('../../lib/data-set/column');
var core_1 = require('@angular/core');
var SearchDescriptionComponent = (function () {
    function SearchDescriptionComponent(changeDetectionRef, searchService) {
        this.changeDetectionRef = changeDetectionRef;
        this.searchService = searchService;
    }
    SearchDescriptionComponent.prototype.ngOnInit = function () {
        var _this = this;
        this.searchService.onSearchAsObservable().subscribe(function (searchParam) {
            if (object_utils_1.ObjectUtils.isNotNullAndUndefined(searchParam.key) && _this.column.id === searchParam.key) {
                _this.value = searchParam.value;
                _this.changeDetectionRef.markForCheck();
            }
        });
    };
    SearchDescriptionComponent.prototype.ngOnChanges = function (changes) {
        if (this.column) {
            this.uniqueId = this.column.uniqueId;
            this.determineDescriptionType();
        }
    };
    SearchDescriptionComponent.prototype.determineDescriptionType = function () {
        var descTemplateHtml = this.column.templateModel.$searchDescriptionTemplateHtml;
        if (object_utils_1.ObjectUtils.isNotNullAndUndefined(descTemplateHtml)) {
            this.descriptType = 'searchDescriptionTemplate';
            this.templateHtml = descTemplateHtml;
        }
        else if (this.column.templateModel.$type) {
            this.descriptType = 'customType';
            var columnType = this.column.templateModel.$type;
            if (columnType === 'number') {
                this.type = 'numeric-search-description';
            }
            else {
                this.type = columnType + '-search-description';
            }
        }
    };
    SearchDescriptionComponent.prototype.dynamicTemplateCallback = function (event) {
        this.changeDetectionRef.markForCheck();
    };
    SearchDescriptionComponent.prototype.clearComponent = function (event) {
        this.value = null;
        this.changeDetectionRef.markForCheck();
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], SearchDescriptionComponent.prototype, "uniqueId", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], SearchDescriptionComponent.prototype, "context", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], SearchDescriptionComponent.prototype, "templateHtml", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', column_1.Column)
    ], SearchDescriptionComponent.prototype, "column", void 0);
    SearchDescriptionComponent = __decorate([
        core_1.Component({
            selector: 'search-description',
            templateUrl: './search-description.component.html',
            changeDetection: core_1.ChangeDetectionStrategy.OnPush
        }), 
        __metadata('design:paramtypes', [core_1.ChangeDetectorRef, smart_table_search_1.SmartTableSearchService])
    ], SearchDescriptionComponent);
    return SearchDescriptionComponent;
}());
exports.SearchDescriptionComponent = SearchDescriptionComponent;
//# sourceMappingURL=search-description.component.js.map