"use strict";
var grid_1 = require('../../lib/grid');
var core_1 = require('@angular/core');
var SmartSelector = (function () {
    function SmartSelector() {
        this.placeHolder = "Select";
        this.edited = new core_1.EventEmitter();
        this.isSelectorEnabled = true;
        this.disabled = false;
    }
    SmartSelector.prototype.onChange = function (event) {
        this.selectedValue = event.target.checked;
        this.edited.emit(this);
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], SmartSelector.prototype, "selectionType", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', grid_1.Grid)
    ], SmartSelector.prototype, "grid", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], SmartSelector.prototype, "placeHolder", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], SmartSelector.prototype, "selectedValue", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], SmartSelector.prototype, "edited", void 0);
    SmartSelector = __decorate([
        core_1.Component({
            selector: 'smart-selector',
            template: "\n    <input type=\"checkbox\" *ngIf=\"isSelectorEnabled\"\n      [ngClass]=\"inputClass\"\n      [(ngModel)]=\"selectedValue\"\n      [placeholder]=\"placeHolder\"\n      [disabled]=\"disabled\"\n      (change)=\"onChange($event)\">\n    "
        }), 
        __metadata('design:paramtypes', [])
    ], SmartSelector);
    return SmartSelector;
}());
exports.SmartSelector = SmartSelector;
//# sourceMappingURL=selector.component.js.map