"use strict";
var data_source_1 = require('../../lib/data-source/data-source');
var template_modal_component_1 = require('../modal/template-modal.component');
var column_1 = require('./../../lib/data-set/column');
var core_1 = require('@angular/core');
var TitleComponent = (function () {
    function TitleComponent() {
        this.currentDirection = 'sort-ctrls';
        this.sorted = new core_1.EventEmitter();
        this.closeOutSide = new core_1.EventEmitter();
        this.isFormVisible = false;
    }
    TitleComponent.prototype.ngOnChanges = function (changes) {
        if (changes['column'])
            this.columnType = this.column.templateModel.$type;
    };
    TitleComponent.prototype.ngOnInit = function () {
        var _this = this;
        if (this.source) {
            this.source.onChanged().subscribe(function (elements) {
                var sortConf = _this.source.getSort();
                if (sortConf.length > 0 && sortConf[0]['field'] === _this.column.id) {
                    _this.currentDirection = sortConf[0]['direction'];
                }
                else {
                    _this.currentDirection = '';
                }
            });
        }
    };
    TitleComponent.prototype.showModal = function (event) {
        this.isFormVisible = true;
    };
    TitleComponent.prototype.sort = function () {
        this.changeSortDirection();
        var sorts = [
            {
                field: this.column.id,
                direction: this.currentDirection,
                compare: null
            }
        ];
        this.source.setSort(sorts);
        this.sorted.emit(sorts);
        return false;
    };
    TitleComponent.prototype.changeSortDirection = function () {
        if (this.currentDirection) {
            this.currentDirection = this.currentDirection === 'st-multi-sort-ascent' ? 'st-multi-sort-descent' : 'st-multi-sort-ascent';
        }
        else {
            this.currentDirection = this.column.sortDirection;
        }
        return this.currentDirection;
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', column_1.Column)
    ], TitleComponent.prototype, "column", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', data_source_1.DataSource)
    ], TitleComponent.prototype, "source", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], TitleComponent.prototype, "currentDirection", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], TitleComponent.prototype, "sorted", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], TitleComponent.prototype, "closeOutSide", void 0);
    TitleComponent = __decorate([
        core_1.Component({
            selector: 'ng2-smart-table-title',
            // styleUrls: ['title.scss'],
            templateUrl: './title.component.html',
            providers: [template_modal_component_1.TemplateModal]
        }), 
        __metadata('design:paramtypes', [])
    ], TitleComponent);
    return TitleComponent;
}());
exports.TitleComponent = TitleComponent;
//# sourceMappingURL=title.component.js.map