import { RowActionModel } from './../../../model/actions/smart-table-action.model';
import { Cell } from './lib/data-set/cell';
import { Column } from './lib/data-set/column';
import { Row } from './lib/data-set/row';
import { DataSource } from './lib/data-source/data-source';
import { Grid } from './lib/grid';
import { ChangeDetectorRef, EventEmitter, OnChanges, SimpleChange } from '@angular/core';
export declare class Ng2SmartTableComponent implements OnChanges {
    private changeDetectRef;
    source: any;
    settings: any;
    selectAll: any;
    selectedRows: any;
    selectedColumns: any;
    selectedPager: any;
    selectedSort: Array<any>;
    rowActionModel: RowActionModel;
    rowSelect: EventEmitter<any>;
    userRowSelect: EventEmitter<any>;
    create: EventEmitter<any>;
    onSelectedRowAction: EventEmitter<any>;
    createConfirm: EventEmitter<any>;
    paginated: EventEmitter<any>;
    pagsChanged: EventEmitter<any>;
    rowSelectionChange: EventEmitter<any>;
    columnSelectionChange: EventEmitter<any>;
    sorted: EventEmitter<any>;
    searched: EventEmitter<any>;
    rowClicked: EventEmitter<any>;
    onPreviousEvent: EventEmitter<any>;
    onNextEvent: EventEmitter<any>;
    protected grid: Grid;
    protected dataSource: DataSource;
    protected pagerData: {
        page: number;
        perPage: number;
    };
    protected defaultSettings: Object;
    colSpanLength: number;
    constructor(changeDetectRef: ChangeDetectorRef);
    protected getColumns(): Column[];
    protected getRows(): Row[];
    protected getColSpanLength(): number;
    protected getCells(row: Row): Cell[];
    ngOnChanges(changes: {
        [propertyName: string]: SimpleChange;
    }): void;
    private updateComponentFromState();
    private onAdd(event);
    private onUserSelectRow(row);
    private onSelectRow(row);
    private onCreate(row, event);
    protected initGrid(): void;
    protected prepareSource(): DataSource;
    protected prepareSettings(): Object;
    protected onHeaderSelectAll(event: any): void;
    protected onSelectAll(selectedValue: any): void;
    protected onRowSelection(event: any, row: Row): void;
    protected updateRowSelections(selectedValue: any): void;
    protected onPaginate(event: any): void;
    protected onColumnFilterChange(event: any): void;
    protected handleRowsForColumnFilter(columnItem: Column): void;
    protected onPageSizeChange(event: any): void;
    protected onColumnSort(sorts: Array<any>): void;
    protected onRowAction(event: any, selectedRow: any): void;
    protected onRowClick(event: Event, row: Row): void;
    protected onNext(row: Row): void;
    protected onPrevious(row: Row): void;
    protected onQuickViewClose(row: Row): void;
}
