import { SmartTableActionService } from '../../services/smart-table-actions.service';
import { SmartTableColumnService } from '../../services/smart-table-column.service';
import { SmartTableActionModel } from './../../model/actions/smart-table-action.model';
import { LocalStorageService } from './../../services/local-storage.service';
import { ActionConfirmModalComponent } from './../confirm-modal/action-confirm-modal.component';
import { Column } from './ng2-smart-table/lib/data-set/column';
import { Row } from './ng2-smart-table/lib/data-set/row';
import { SmartTableSearchService } from './services/smart-table-search';
import { Injector, OnChanges, SimpleChange, ChangeDetectorRef } from '@angular/core';
import { EventEmitter, OnInit } from '@angular/core';
import { Observable, Subject } from 'rxjs/Rx';
export declare class SmartTableComponent implements OnChanges, OnInit {
    private injector;
    private changeDetectRef;
    private localStorageService;
    confirm: ActionConfirmModalComponent;
    protected columnJson: string;
    protected data: Array<Object>;
    protected storageKey: string;
    protected actionModel: SmartTableActionModel;
    onHeaderEvent: EventEmitter<any>;
    onRowEvent: EventEmitter<any>;
    onBulkEvent: EventEmitter<any>;
    onColumnSortEvent: EventEmitter<any>;
    onPaginateEvent: EventEmitter<any>;
    onColumnSearchEvent: EventEmitter<any>;
    onRowClickEvent: EventEmitter<any>;
    onPreviousRowEvent: EventEmitter<any>;
    onNextRowEvent: EventEmitter<any>;
    settingsSource: Subject<any>;
    settings$: Observable<any>;
    dataSource: Subject<any>;
    dataSource$: Observable<any>;
    columnService: SmartTableColumnService;
    actionService: SmartTableActionService;
    searchService: SmartTableSearchService;
    private smartTableStorageActions;
    sortSelections: any;
    columnSelections: any;
    pagerSelections: any;
    rowSelections: any;
    constructor(injector: Injector, changeDetectRef: ChangeDetectorRef, localStorageService: LocalStorageService);
    ngOnChanges(changes: {
        [propertyName: string]: SimpleChange;
    }): void;
    ngOnInit(): void;
    private initConfirmationMessageSubscribe();
    private initSearchSubscribe();
    private initActionSubscribe();
    private setSettings(columnJsonName);
    protected onPaginate(event: any): void;
    protected onPageSizeChanged(event: any): void;
    protected onRowSelectionChange(rows?: Array<Row>): void;
    protected onColumnSelectionChange(columns: Array<Column>): void;
    protected onColumnSort(sorts: [{
        field: 'temp';
        direction: 'asc';
        compare: null;
    }]): void;
    protected onHeaderAction(event: any): void;
    protected onRowAction(event: any): void;
    protected onBulkAction(event: any): void;
    onRowClick(event: any): void;
    onPrevious(event: any): void;
    onNext(event: any): void;
}
