import { Comparator, PathSelector, PropertySelector } from '../services/local-storage.service';
export declare type PropertyDecorator = (target: any, propertyKey: string) => void;
/**
 * Selects an observable from the store, and attaches it to the decorated
 * property.
 *
 * @param { PropertySelector | PathSelector} selector
 * property name string, or property name path
 * (array of strings/array indices) that locates the store data to be
 * selected
 *
 * @param { Comparator } comparer function for this selector
 */
export declare function select<T>(selector?: PropertySelector | PathSelector, comparator?: Comparator): PropertyDecorator;
